/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowsGroup
extends ActionGroup {
    private static final HashMap<String, MyDescriptor> ourId2Text = new HashMap();
    private final ArrayList<ActivateToolWindowAction> myChildren = new ArrayList();
    private final MyToolWindowManagerListener myToolWindowManagerListener = new MyToolWindowManagerListener();

    public ToolWindowsGroup(ProjectManager projectManager) {
        projectManager.addProjectManagerListener((ProjectManagerListener)new MyProjectManagerListener());
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = this.myChildren.toArray(new AnAction[this.myChildren.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToolWindowsGroup", "getChildren"));
        }
        return anActionArray;
    }

    private void addActionForToolWindow(String id) {
        for (ActivateToolWindowAction action : this.myChildren) {
            if (!action.getToolWindowId().equals(id)) continue;
            return;
        }
        MyDescriptor descriptor = (MyDescriptor)ourId2Text.get((Object)id);
        String text = descriptor != null ? descriptor.myText : id;
        Icon icon = descriptor != null ? descriptor.myIcon : null;
        ActivateToolWindowAction action = new ActivateToolWindowAction(id, text, icon);
        ActionManager.getInstance().registerAction(ActivateToolWindowAction.getActionIdForToolWindow(id), (AnAction)action);
        this.myChildren.add(action);
        Collections.sort(this.myChildren, MyActionComparator.ourInstance);
    }

    static {
        ourId2Text.put((Object)ToolWindowId.COMMANDER, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.commander", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowCommander));
        ourId2Text.put((Object)ToolWindowId.MESSAGES_WINDOW, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.messages", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowMessages));
        ourId2Text.put((Object)ToolWindowId.PROJECT_VIEW, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.project", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowProject));
        ourId2Text.put((Object)ToolWindowId.STRUCTURE_VIEW, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.structure", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowStructure));
        ourId2Text.put((Object)ToolWindowId.ANT_BUILD, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.ant.build", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowAnt));
        ourId2Text.put((Object)ToolWindowId.DEBUG, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.debug", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowDebugger));
        ourId2Text.put((Object)ToolWindowId.RUN, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.run", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowRun));
        ourId2Text.put((Object)ToolWindowId.FIND, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.find", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowFind));
        ourId2Text.put((Object)ToolWindowId.CVS, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.cvs", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowCvs));
        ourId2Text.put((Object)ToolWindowId.HIERARCHY, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.hierarchy", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowHierarchy));
        ourId2Text.put((Object)ToolWindowId.TODO_VIEW, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.todo", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowTodo));
        ourId2Text.put((Object)ToolWindowId.INSPECTION, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.inspection", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowInspection));
        ourId2Text.put((Object)ToolWindowId.FAVORITES_VIEW, (Object)new MyDescriptor(IdeBundle.message((String)"action.toolwindow.favorites", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowFavorites));
    }

    private static final class MyDescriptor {
        public final String myText;
        public final Icon myIcon;

        public MyDescriptor(String text, Icon icon) {
            this.myText = text;
            this.myIcon = icon;
        }
    }

    private final class MyToolWindowManagerListener
    extends ToolWindowManagerAdapter {
        private MyToolWindowManagerListener() {
        }

        @Override
        public void toolWindowRegistered(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/ToolWindowsGroup$MyToolWindowManagerListener", "toolWindowRegistered"));
            }
            ToolWindowsGroup.this.addActionForToolWindow(id);
        }
    }

    private static final class MyActionComparator
    implements Comparator<ActivateToolWindowAction> {
        public static final MyActionComparator ourInstance = new MyActionComparator();

        private MyActionComparator() {
        }

        @Override
        public int compare(ActivateToolWindowAction action1, ActivateToolWindowAction action2) {
            int mnemonic1 = ActivateToolWindowAction.getMnemonicForToolWindow(action1.getToolWindowId());
            int mnemonic2 = ActivateToolWindowAction.getMnemonicForToolWindow(action2.getToolWindowId());
            if (mnemonic1 != -1 && mnemonic2 == -1) {
                return -1;
            }
            if (mnemonic1 == -1 && mnemonic2 != -1) {
                return 1;
            }
            if (mnemonic1 != -1) {
                return mnemonic1 - mnemonic2;
            }
            return action1.getToolWindowId().compareToIgnoreCase(action2.getToolWindowId());
        }
    }

    private final class MyProjectManagerListener
    extends ProjectManagerAdapter {
        private MyProjectManagerListener() {
        }

        public void projectClosed(Project project) {
            ToolWindowManagerEx windowManagerEx = ToolWindowManagerEx.getInstanceEx(project);
            if (windowManagerEx == null) {
                return;
            }
            windowManagerEx.removeToolWindowManagerListener(ToolWindowsGroup.this.myToolWindowManagerListener);
        }

        public void projectOpened(Project project) {
            String[] ids;
            ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project);
            if (toolWindowManager == null) {
                return;
            }
            for (String id : ids = toolWindowManager.getToolWindowIds()) {
                ToolWindowsGroup.this.addActionForToolWindow(id);
            }
            toolWindowManager.addToolWindowManagerListener(ToolWindowsGroup.this.myToolWindowManagerListener);
        }
    }
}

