/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class ToggleFullScreenAction
extends AnAction
implements DumbAware {
    private static final String TEXT_ENTER_FULL_SCREEN = ActionsBundle.message((String)"action.ToggleFullScreen.text.enter", (Object[])new Object[0]);
    private static final String TEXT_EXIT_FULL_SCREEN = ActionsBundle.message((String)"action.ToggleFullScreen.text.exit", (Object[])new Object[0]);

    public void actionPerformed(AnActionEvent e) {
        IdeFrameEx frame = ToggleFullScreenAction.getFrame();
        if (frame != null) {
            frame.toggleFullScreen(!frame.isInFullScreen());
        }
    }

    public void update(AnActionEvent e) {
        Presentation p = e.getPresentation();
        IdeFrameEx frame = null;
        boolean isApplicable = WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (frame = ToggleFullScreenAction.getFrame()) != null;
        p.setVisible(isApplicable);
        p.setEnabled(isApplicable);
        if (isApplicable) {
            p.setText(frame.isInFullScreen() ? TEXT_EXIT_FULL_SCREEN : TEXT_ENTER_FULL_SCREEN);
        }
    }

    @Nullable
    private static IdeFrameEx getFrame() {
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        if (focusOwner != null) {
            Window window;
            Window window2 = window = focusOwner instanceof JFrame ? (Window)focusOwner : SwingUtilities.getWindowAncestor(focusOwner);
            if (window instanceof IdeFrameEx) {
                return (IdeFrameEx)((Object)window);
            }
        }
        return null;
    }
}

