/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.SwitcherToolWindowsListRenderer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.SpeedSearchObjectWithWeight;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Switcher
extends AnAction
implements DumbAware {
    private static volatile SwitcherPanel SWITCHER;
    private static final Color BORDER_COLOR;
    private static final Color SEPARATOR_COLOR;
    @NonNls
    private static final String SWITCHER_FEATURE_ID = "switcher";
    private static final Color ON_MOUSE_OVER_BG_COLOR;
    private static int CTRL_KEY;
    private static int ALT_KEY;
    public static final Runnable CHECKER;
    private static final Map<String, Integer> TW_KEYMAP;
    private static final CustomShortcutSet TW_SHORTCUT;
    @NonNls
    private static final String SWITCHER_TITLE = "Switcher";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        Class<Switcher> clazz = Switcher.class;
        synchronized (Switcher.class) {
            if (SWITCHER != null && SWITCHER.isPinnedMode()) {
                Switcher.SWITCHER.cancel();
                SWITCHER = null;
            }
            if (SWITCHER == null) {
                SWITCHER = Switcher.createAndShowSwitcher(project, SWITCHER_TITLE, false);
                FeatureUsageTracker.getInstance().triggerFeatureUsed(SWITCHER_FEATURE_ID);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            assert (SWITCHER != null);
            if (!SWITCHER.isPinnedMode()) {
                if (e.getInputEvent().isShiftDown()) {
                    SWITCHER.goBack();
                } else if (!FileEditorManagerEx.getInstanceEx(project).hasOpenedFile()) {
                    Switcher.SWITCHER.files.setSelectedIndex(0);
                } else {
                    SWITCHER.goForward();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SwitcherPanel createAndShowSwitcher(Project project, String title, boolean pinned) {
        Class<Switcher> clazz = Switcher.class;
        synchronized (Switcher.class) {
            if (SWITCHER != null) {
                Switcher.SWITCHER.cancel();
            }
            SWITCHER = new SwitcherPanel(project, title, pinned);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return SWITCHER;
        }
    }

    static {
        char ch;
        SWITCHER = null;
        BORDER_COLOR = Gray._135;
        SEPARATOR_COLOR = new JBColor(BORDER_COLOR.brighter(), (Color)Gray._75);
        ON_MOUSE_OVER_BG_COLOR = new JBColor(new Color(231, 242, 249), new Color(77, 80, 84));
        CHECKER = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<Switcher> clazz = Switcher.class;
                synchronized (Switcher.class) {
                    if (SWITCHER != null) {
                        SWITCHER.navigate();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        TW_KEYMAP = new HashMap<String, Integer>();
        TW_KEYMAP.put("Messages", 0);
        TW_KEYMAP.put("Project", 1);
        TW_KEYMAP.put("Favorites", 2);
        TW_KEYMAP.put("Find", 3);
        TW_KEYMAP.put("Run", 4);
        TW_KEYMAP.put("Debug", 5);
        TW_KEYMAP.put("TODO", 6);
        TW_KEYMAP.put("Structure", 7);
        TW_KEYMAP.put("Hierarchy", 8);
        TW_KEYMAP.put("Changes", 9);
        ArrayList<Shortcut> shortcuts = new ArrayList<Shortcut>();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            shortcuts.add(CustomShortcutSet.fromString((String[])new String[]{"control " + ch}).getShortcuts()[0]);
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            shortcuts.add(CustomShortcutSet.fromString((String[])new String[]{"control " + ch}).getShortcuts()[0]);
        }
        TW_SHORTCUT = new CustomShortcutSet(shortcuts.toArray(new Shortcut[shortcuts.size()]));
        IdeEventQueue.getInstance().addPostprocessor(new IdeEventQueue.EventDispatcher(){

            @Override
            public boolean dispatch(AWTEvent event) {
                if (SWITCHER != null && event instanceof KeyEvent && !SWITCHER.isPinnedMode()) {
                    ToolWindow tw;
                    KeyEvent keyEvent = (KeyEvent)event;
                    if (event.getID() == 402 && keyEvent.getKeyCode() == CTRL_KEY) {
                        SwingUtilities.invokeLater(CHECKER);
                    } else if (event.getID() == 401 && (tw = SWITCHER.twShortcuts.get(String.valueOf((char)keyEvent.getKeyCode()))) != null) {
                        SWITCHER.myPopup.closeOk(null);
                        tw.activate(null, true, true);
                    }
                }
                return false;
            }
        }, null);
    }

    private static class MyList
    extends JBList {
        public MyList(DefaultListModel model) {
            super((ListModel)model);
        }

        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }
    }

    private static class FileInfo
    extends Pair<VirtualFile, EditorWindow> {
        public FileInfo(VirtualFile first, EditorWindow second) {
            super((Object)first, (Object)second);
        }
    }

    private static class VirtualFilesRenderer
    extends ColoredListCellRenderer {
        private final SwitcherPanel mySwitcherPanel;
        boolean open;

        public VirtualFilesRenderer(@NotNull SwitcherPanel switcherPanel) {
            if (switcherPanel == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/Switcher$VirtualFilesRenderer", "<init>"));
            }
            this.mySwitcherPanel = switcherPanel;
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof FileInfo) {
                Project project = this.mySwitcherPanel.project;
                VirtualFile virtualFile = (VirtualFile)((FileInfo)((Object)value)).getFirst();
                String name = virtualFile instanceof VirtualFilePathWrapper ? ((VirtualFilePathWrapper)virtualFile).getPresentablePath() : (UISettings.getInstance().SHOW_DIRECTORY_FOR_NON_UNIQUE_FILENAMES ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, virtualFile) : virtualFile.getName());
                this.setIcon(IconUtil.getIcon((VirtualFile)virtualFile, (int)2, (Project)project));
                FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
                this.open = FileEditorManager.getInstance((Project)project).isFileOpen(virtualFile);
                TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, null, EffectType.LINE_UNDERSCORE, 0);
                this.append(name, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                Color color = EditorTabbedContainer.calcTabColor(project, virtualFile);
                if (!selected && color != null) {
                    this.setBackground(color);
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)this.mySwitcherPanel, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
            }
        }
    }

    public static class SwitcherPanel
    extends JPanel
    implements KeyListener,
    MouseListener,
    MouseMotionListener {
        private final int MAX_FILES_IN_SWITCHER;
        final JBPopup myPopup;
        final Map<ToolWindow, String> ids = new HashMap<ToolWindow, String>();
        final MyList toolWindows;
        final MyList files;
        final JPanel separator;
        final ToolWindowManager twManager;
        final JLabel pathLabel = new JLabel(" ");
        final JPanel descriptions;
        final Project project;
        private final boolean myPinned;
        final Map<String, ToolWindow> twShortcuts;
        final Alarm myAlarm;
        final SwitcherSpeedSearch mySpeedSearch;
        final ClickListener myClickListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/Switcher$SwitcherPanel$1", "onClick"));
                }
                if (SwitcherPanel.this.myPinned && (e.isControlDown() || e.isMetaDown() || e.isShiftDown())) {
                    return false;
                }
                Object source = e.getSource();
                if (source instanceof JList) {
                    JList jList = (JList)source;
                    if (jList.getSelectedIndex() == -1 && jList.getAnchorSelectionIndex() != -1) {
                        jList.setSelectedIndex(jList.getAnchorSelectionIndex());
                    }
                    if (jList.getSelectedIndex() != -1) {
                        SwitcherPanel.this.navigate();
                    }
                }
                return true;
            }
        };
        KeyEvent lastEvent;
        private boolean mouseMovedFirstTime = true;
        private JList mouseMoveSrc = null;
        private int mouseMoveListIndex = -1;

        SwitcherPanel(Project project, String title, boolean pinned) {
            this.setLayout(new SwitcherLayouter());
            this.project = project;
            this.MAX_FILES_IN_SWITCHER = pinned ? UISettings.getInstance().RECENT_FILES_LIMIT : 30;
            this.myPinned = pinned;
            this.mySpeedSearch = pinned ? new SwitcherSpeedSearch() : null;
            this.setFocusable(true);
            this.addKeyListener(this);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.setBackground(JBColor.background());
            this.pathLabel.setHorizontalAlignment(2);
            Font font = this.pathLabel.getFont();
            this.pathLabel.setFont(font.deriveFont(Math.max(10.0f, (float)font.getSize() - 4.0f)));
            this.descriptions = new JPanel(new BorderLayout()){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.setColor(UIUtil.isUnderDarcula() ? SEPARATOR_COLOR : BORDER_COLOR);
                    g.drawLine(0, 0, this.getWidth(), 0);
                }
            };
            this.descriptions.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
            this.descriptions.add((Component)this.pathLabel, "Center");
            this.twManager = ToolWindowManager.getInstance((Project)project);
            DefaultListModel<ToolWindow> twModel = new DefaultListModel<ToolWindow>();
            for (String id : this.twManager.getToolWindowIds()) {
                ToolWindow tw = this.twManager.getToolWindow(id);
                if (!tw.isAvailable()) continue;
                this.ids.put(tw, id);
            }
            ArrayList<ToolWindow> windows = new ArrayList<ToolWindow>(this.ids.keySet());
            this.twShortcuts = this.createShortcuts(windows);
            final Map map = ContainerUtil.reverseMap(this.twShortcuts);
            Collections.sort(windows, new Comparator<ToolWindow>(){

                @Override
                public int compare(ToolWindow o1, ToolWindow o2) {
                    return ((String)map.get(o1)).compareTo((String)map.get(o2));
                }
            });
            for (ToolWindow window : windows) {
                twModel.addElement(window);
            }
            this.toolWindows = new MyList(twModel);
            if (pinned) {
                new NameFilteringListModel((JList)((Object)this.toolWindows), (Function)new Function<ToolWindow, String>(){

                    public String fun(ToolWindow window) {
                        return SwitcherPanel.this.ids.get(window);
                    }
                }, (Condition)new Condition<String>(){

                    public boolean value(String s) {
                        return !SwitcherPanel.this.mySpeedSearch.isPopupActive() || StringUtil.isEmpty((String)SwitcherPanel.this.mySpeedSearch.getEnteredPrefix()) || SwitcherPanel.this.mySpeedSearch.getComparator().matchingFragments(SwitcherPanel.this.mySpeedSearch.getEnteredPrefix(), s) != null;
                    }
                }, (SpeedSearchSupply)this.mySpeedSearch);
            }
            this.toolWindows.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)20));
            this.toolWindows.setSelectionMode(pinned ? 2 : 0);
            this.toolWindows.setCellRenderer((ListCellRenderer)((Object)new SwitcherToolWindowsListRenderer(this.mySpeedSearch, this.ids, map, this.myPinned){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    JComponent renderer = (JComponent)super.getListCellRendererComponent(list, value, index, selected, hasFocus);
                    if (selected) {
                        return renderer;
                    }
                    Color bgColor = list == SwitcherPanel.this.mouseMoveSrc && index == SwitcherPanel.this.mouseMoveListIndex ? ON_MOUSE_OVER_BG_COLOR : list.getBackground();
                    UIUtil.changeBackGround((Component)renderer, (Color)bgColor);
                    return renderer;
                }
            }));
            this.toolWindows.addKeyListener(this);
            this.toolWindows.addMouseListener(this);
            this.toolWindows.addMouseMotionListener(this);
            this.myClickListener.installOn((Component)((Object)this.toolWindows));
            this.toolWindows.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!SwitcherPanel.this.toolWindows.isSelectionEmpty() && !SwitcherPanel.this.files.isSelectionEmpty()) {
                        SwitcherPanel.this.files.clearSelection();
                    }
                }
            });
            this.separator = new JPanel(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.setColor(SEPARATOR_COLOR);
                    g.drawLine(0, 0, 0, this.getHeight());
                }
            };
            this.separator.setBackground(this.toolWindows.getBackground());
            int selectionIndex = -1;
            FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project);
            ArrayList filesData = new ArrayList();
            ArrayList<FileInfo> editors = new ArrayList<FileInfo>();
            if (!pinned) {
                for (Pair<VirtualFile, EditorWindow> pair : editorManager.getSelectionHistory()) {
                    editors.add(new FileInfo((VirtualFile)pair.first, (EditorWindow)pair.second));
                }
            }
            if (editors.size() < 2 || this.isPinnedMode()) {
                if (this.isPinnedMode() && editors.size() > 1) {
                    filesData.addAll(editors);
                }
                VirtualFile[] recentFiles = (VirtualFile[])ArrayUtil.reverseArray((Object[])EditorHistoryManager.getInstance(project).getFiles());
                int maxFiles = Math.max(editors.size(), recentFiles.length);
                int len = this.isPinnedMode() ? recentFiles.length : Math.min(this.toolWindows.getModel().getSize(), maxFiles);
                boolean firstRecentMarked = false;
                List<VirtualFile> selectedFiles = Arrays.asList(editorManager.getSelectedFiles());
                for (int i = 0; i < len; ++i) {
                    if (this.isPinnedMode() && selectedFiles.contains(recentFiles[i])) continue;
                    FileInfo info = new FileInfo(recentFiles[i], null);
                    boolean add = true;
                    if (this.isPinnedMode()) {
                        for (FileInfo fileInfo : filesData) {
                            if (!((VirtualFile)fileInfo.first).equals(info.first)) continue;
                            add = false;
                            break;
                        }
                    }
                    if (!add) continue;
                    filesData.add(info);
                    if (firstRecentMarked) continue;
                    firstRecentMarked = true;
                    selectionIndex = filesData.size() - 1;
                }
                if (editors.size() == 1) {
                    ++selectionIndex;
                }
                if (editors.size() == 1 && (filesData.isEmpty() || !((VirtualFile)((FileInfo)((Object)editors.get(0))).getFirst()).equals(((FileInfo)((Object)filesData.get(0))).getFirst()))) {
                    filesData.add(0, editors.get(0));
                }
            } else {
                for (int i = 0; i < Math.min(this.MAX_FILES_IN_SWITCHER, editors.size()); ++i) {
                    filesData.add(editors.get(i));
                }
            }
            DefaultListModel<FileInfo> filesModel = new DefaultListModel<FileInfo>();
            for (FileInfo editor : filesData) {
                filesModel.addElement(editor);
            }
            VirtualFilesRenderer filesRenderer = new VirtualFilesRenderer(this){
                JPanel myPanel;
                JLabel myLabel;
                {
                    this.myPanel = new JPanel(new BorderLayout());
                    this.myLabel = new JLabel(){

                        @Override
                        protected void paintComponent(Graphics g) {
                            GraphicsConfig config = new GraphicsConfig(g);
                            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.3f));
                            super.paintComponent(g);
                            config.restore();
                        }
                    };
                    this.myPanel.setOpaque(false);
                    this.myPanel.setBackground(UIUtil.getListBackground());
                    this.myLabel.setText("* ");
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    Component c = super.getListCellRendererComponent(list, value, index, selected, hasFocus);
                    Color bg = UIUtil.getListBackground();
                    Color fg = UIUtil.getListForeground();
                    this.myLabel.setFont(list.getFont());
                    this.myLabel.setForeground(this.open ? fg : bg);
                    this.myPanel.removeAll();
                    this.myPanel.add((Component)this.myLabel, "West");
                    this.myPanel.add(c, "Center");
                    return this.myPanel;
                }
            };
            ListSelectionListener filesSelectionListener = new ListSelectionListener(){

                private String getTitle2Text(String fullText) {
                    int labelWidth = SwitcherPanel.this.pathLabel.getWidth();
                    if (fullText == null || fullText.length() == 0) {
                        return " ";
                    }
                    while (SwitcherPanel.this.pathLabel.getFontMetrics(SwitcherPanel.this.pathLabel.getFont()).stringWidth(fullText) > labelWidth) {
                        int sep = fullText.indexOf(File.separatorChar, 4);
                        if (sep < 0) {
                            return fullText;
                        }
                        fullText = "..." + fullText.substring(sep);
                    }
                    return fullText;
                }

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.updatePathLabel();
                        }
                    });
                }

                private void updatePathLabel() {
                    Object[] values = SwitcherPanel.this.files.getSelectedValues();
                    if (values != null && values.length == 1) {
                        VirtualFile parent = ((VirtualFile)((FileInfo)((Object)values[0])).first).getParent();
                        if (parent != null) {
                            SwitcherPanel.this.pathLabel.setText(this.getTitle2Text(FileUtil.getLocationRelativeToUserHome((String)parent.getPresentableUrl())));
                        } else {
                            SwitcherPanel.this.pathLabel.setText(" ");
                        }
                    } else {
                        SwitcherPanel.this.pathLabel.setText(" ");
                    }
                }
            };
            this.files = new MyList(filesModel);
            if (pinned) {
                new NameFilteringListModel((JList)((Object)this.files), (Function)new Function<FileInfo, String>(){

                    public String fun(FileInfo info) {
                        VirtualFile file = (VirtualFile)info.getFirst();
                        return file instanceof VirtualFilePathWrapper ? ((VirtualFilePathWrapper)file).getPresentablePath() : file.getName();
                    }
                }, (Condition)new Condition<String>(){

                    public boolean value(String s) {
                        return !SwitcherPanel.this.mySpeedSearch.isPopupActive() || StringUtil.isEmpty((String)SwitcherPanel.this.mySpeedSearch.getEnteredPrefix()) || SwitcherPanel.this.mySpeedSearch.getComparator().matchingFragments(SwitcherPanel.this.mySpeedSearch.getEnteredPrefix(), s) != null;
                    }
                }, (SpeedSearchSupply)this.mySpeedSearch);
            }
            this.files.setSelectionMode(pinned ? 2 : 0);
            this.files.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!SwitcherPanel.this.files.isSelectionEmpty() && !SwitcherPanel.this.toolWindows.isSelectionEmpty()) {
                        SwitcherPanel.this.toolWindows.getSelectionModel().clearSelection();
                    }
                }
            });
            this.files.getSelectionModel().addListSelectionListener(filesSelectionListener);
            this.files.setCellRenderer((ListCellRenderer)((Object)filesRenderer));
            this.files.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)20));
            this.files.addKeyListener(this);
            this.files.addMouseListener(this);
            this.files.addMouseMotionListener(this);
            this.myClickListener.installOn((Component)((Object)this.files));
            this.add((Component)((Object)this.toolWindows), "West");
            if (filesModel.size() > 0) {
                this.files.setAlignmentY(1.0f);
                if (this.files.getModel().getSize() > 20) {
                    JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)((Object)this.files), (boolean)true);
                    pane.setPreferredSize(new Dimension(this.files.getPreferredSize().width + 10, 400));
                    pane.setHorizontalScrollBarPolicy(31);
                    this.add((Component)pane, "East");
                } else {
                    this.add((Component)((Object)this.files), "East");
                }
                if (selectionIndex > -1) {
                    this.files.setSelectedIndex(selectionIndex);
                }
                this.add((Component)this.separator, "Center");
            }
            this.add((Component)this.descriptions, "South");
            ShortcutSet shortcutSet = ActionManager.getInstance().getAction(Switcher.SWITCHER_TITLE).getShortcutSet();
            int modifiers = SwitcherPanel.getModifiers(shortcutSet);
            boolean isAlt = (modifiers & 8) != 0;
            ALT_KEY = isAlt ? 17 : 18;
            CTRL_KEY = isAlt ? 18 : 17;
            IdeFrameImpl ideFrame = WindowManagerEx.getInstanceEx().getFrame(project);
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, (JComponent)this).setResizable(pinned).setModalContext(false).setFocusable(true).setRequestFocus(true).setTitle(title).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(pinned).setCancelKeyEnabled(false).setCancelCallback((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    SWITCHER = null;
                    return true;
                }
            }).createPopup();
            if (this.isPinnedMode()) {
                new AnAction(null, null, null){

                    public void actionPerformed(AnActionEvent e) {
                        SwitcherPanel.this.changeSelection();
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), (JComponent)this, (Disposable)this.myPopup);
                new AnAction(null, null, null){

                    public void actionPerformed(AnActionEvent e) {
                    }
                }.registerCustomShortcutSet((ShortcutSet)TW_SHORTCUT, (JComponent)this, (Disposable)this.myPopup);
                new AnAction(null, null, null){

                    public void actionPerformed(AnActionEvent e) {
                        if (SwitcherPanel.this.mySpeedSearch != null && SwitcherPanel.this.mySpeedSearch.isPopupActive()) {
                            SwitcherPanel.this.mySpeedSearch.hidePopup();
                        } else {
                            SwitcherPanel.this.myPopup.cancel();
                        }
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ESCAPE"}), (JComponent)this, (Disposable)this.myPopup);
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myPopup);
            this.myPopup.showInCenterOf((Component)window);
        }

        private Map<String, ToolWindow> createShortcuts(List<ToolWindow> windows) {
            HashMap<String, ToolWindow> keymap = new HashMap<String, ToolWindow>(windows.size());
            ArrayList<ToolWindow> pluginToolWindows = new ArrayList<ToolWindow>();
            for (ToolWindow window : windows) {
                Integer index = (Integer)TW_KEYMAP.get(this.ids.get(window));
                if (index != null) {
                    keymap.put(Integer.toString(index, index + 1).toUpperCase(), window);
                    continue;
                }
                pluginToolWindows.add(window);
            }
            Iterator iterator = pluginToolWindows.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                while (keymap.get(Integer.toString(i, i + 1).toUpperCase()) != null) {
                    ++i;
                }
                keymap.put(Integer.toString(i, i + 1).toUpperCase(), (ToolWindow)iterator.next());
                ++i;
            }
            return keymap;
        }

        private static int getModifiers(ShortcutSet shortcutSet) {
            if (shortcutSet == null || shortcutSet.getShortcuts().length == 0 || !(shortcutSet.getShortcuts()[0] instanceof KeyboardShortcut)) {
                return 2;
            }
            return ((KeyboardShortcut)shortcutSet.getShortcuts()[0]).getFirstKeyStroke().getModifiers();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == CTRL_KEY && this.isAutoHide() || e.getKeyCode() == 10) {
                this.navigate();
            } else if (e.getKeyCode() == 37) {
                this.goLeft();
            } else if (e.getKeyCode() == 39) {
                this.goRight();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive() || this.lastEvent == e) {
                return;
            }
            this.lastEvent = e;
            switch (e.getKeyCode()) {
                case 38: {
                    if (!this.isPinnedMode()) {
                        this.goBack();
                        break;
                    }
                    this.getSelectedList().processKeyEvent(e);
                    break;
                }
                case 40: {
                    if (!this.isPinnedMode()) {
                        this.goForward();
                        break;
                    }
                    this.getSelectedList().processKeyEvent(e);
                    break;
                }
                case 27: {
                    this.cancel();
                    break;
                }
                case 35: {
                    ListScrollingUtil.moveEnd((JList)((Object)this.getSelectedList()));
                    break;
                }
                case 34: {
                    ListScrollingUtil.movePageDown((JList)((Object)this.getSelectedList()));
                    break;
                }
                case 36: {
                    ListScrollingUtil.moveHome((JList)((Object)this.getSelectedList()));
                    break;
                }
                case 33: {
                    ListScrollingUtil.movePageUp((JList)((Object)this.getSelectedList()));
                    break;
                }
                case 8: 
                case 81: 
                case 127: {
                    this.closeTabOrToolWindow();
                }
            }
            if (e.getKeyCode() == ALT_KEY) {
                this.changeSelection();
            }
        }

        private void changeSelection() {
            if (this.isFilesSelected()) {
                this.goLeft();
            } else {
                this.goRight();
            }
        }

        private void closeTabOrToolWindow() {
            int[] selected = this.getSelectedList().getSelectedIndices();
            Arrays.sort(selected);
            int selectedIndex = 0;
            for (int i = selected.length - 1; i >= 0; --i) {
                selectedIndex = selected[i];
                Object value = this.getSelectedList().getModel().getElementAt(selectedIndex);
                if (value instanceof FileInfo) {
                    FileInfo info = (FileInfo)((Object)value);
                    VirtualFile virtualFile = (VirtualFile)info.first;
                    FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project);
                    MyList jList = this.getSelectedList();
                    EditorWindow wnd = SwitcherPanel.findAppropriateWindow(info);
                    if (wnd == null) {
                        editorManager.closeFile(virtualFile, false, false);
                    } else {
                        editorManager.closeFile(virtualFile, wnd, false);
                    }
                    final IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.project);
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            focusManager.requestFocus((Component)SwitcherPanel.this, true);
                        }
                    }, 300);
                    if (((JList)((Object)jList)).getModel().getSize() == 1) {
                        this.goLeft();
                        SwitcherPanel.removeElementAt((JList)((Object)jList), selectedIndex);
                        this.remove((Component)((Object)jList));
                        this.remove(this.separator);
                        Dimension size = this.toolWindows.getSize();
                        this.myPopup.setSize(new Dimension(size.width, this.myPopup.getSize().height));
                    } else {
                        SwitcherPanel.removeElementAt((JList)((Object)jList), selectedIndex);
                        ((Component)((Object)jList)).setSize(((JComponent)((Object)jList)).getPreferredSize());
                    }
                    if (!this.isPinnedMode()) continue;
                    EditorHistoryManager.getInstance(this.project).removeFile(virtualFile);
                    continue;
                }
                if (!(value instanceof ToolWindow)) continue;
                ToolWindow toolWindow = (ToolWindow)value;
                if (this.twManager instanceof ToolWindowManagerImpl) {
                    ToolWindowManagerImpl manager = (ToolWindowManagerImpl)this.twManager;
                    manager.hideToolWindow(this.ids.get(toolWindow), false, false);
                    continue;
                }
                toolWindow.hide(null);
            }
            this.pack();
            this.myPopup.getContent().revalidate();
            this.myPopup.getContent().repaint();
            if (this.getSelectedList().getModel().getSize() > selectedIndex) {
                this.getSelectedList().setSelectedIndex(selectedIndex);
                this.getSelectedList().ensureIndexIsVisible(selectedIndex);
            }
        }

        private static void removeElementAt(JList jList, int index) {
            ListModel model = jList.getModel();
            if (model instanceof DefaultListModel) {
                ((DefaultListModel)model).removeElementAt(index);
            } else if (model instanceof NameFilteringListModel) {
                ((NameFilteringListModel)model).remove(index);
            } else {
                throw new IllegalArgumentException("Wrong list model " + model.getClass());
            }
        }

        private void pack() {
            this.setSize(this.getPreferredSize());
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            Container container = this;
            do {
                container = container.getParent();
                container.setSize(container.getPreferredSize());
            } while (container != rootPane);
            container.getParent().setSize(container.getPreferredSize());
        }

        private boolean isFilesSelected() {
            return this.getSelectedList() == this.files;
        }

        private boolean isFilesVisible() {
            return this.files.getModel().getSize() > 0;
        }

        private boolean isToolWindowsSelected() {
            return this.getSelectedList() == this.toolWindows;
        }

        private void goRight() {
            if ((this.isFilesSelected() || !this.isFilesVisible()) && this.isAutoHide()) {
                this.cancel();
            } else if (this.files.getModel().getSize() > 0) {
                int index = Math.min(this.toolWindows.getSelectedIndex(), this.files.getModel().getSize() - 1);
                this.files.setSelectedIndex(index);
                this.files.ensureIndexIsVisible(index);
                this.toolWindows.getSelectionModel().clearSelection();
            }
        }

        private void cancel() {
            this.myPopup.cancel();
        }

        private void goLeft() {
            if (this.isToolWindowsSelected() && this.isAutoHide()) {
                this.cancel();
            } else if (this.toolWindows.getModel().getSize() > 0) {
                this.toolWindows.setSelectedIndex(Math.min(this.files.getSelectedIndex(), this.toolWindows.getModel().getSize() - 1));
                this.files.getSelectionModel().clearSelection();
            }
        }

        public void goForward() {
            MyList list = this.getSelectedList();
            int index = ((JList)((Object)list)).getSelectedIndex() + 1;
            if (index >= ((JList)((Object)list)).getModel().getSize()) {
                index = 0;
                if (this.isFilesVisible()) {
                    list = this.isFilesSelected() ? this.toolWindows : this.files;
                }
            }
            ((JList)((Object)list)).setSelectedIndex(index);
            ((JList)((Object)list)).ensureIndexIsVisible(index);
        }

        public void goBack() {
            MyList list = this.getSelectedList();
            int index = ((JList)((Object)list)).getSelectedIndex() - 1;
            if (index < 0) {
                if (this.isFilesVisible()) {
                    list = this.isFilesSelected() ? this.toolWindows : this.files;
                }
                index = ((JList)((Object)list)).getModel().getSize() - 1;
            }
            ((JList)((Object)list)).setSelectedIndex(index);
            ((JList)((Object)list)).ensureIndexIsVisible(index);
        }

        public MyList getSelectedList() {
            return this.getSelectedList(this.files);
        }

        MyList getSelectedList(MyList preferable) {
            if (this.toolWindows.isSelectionEmpty() && this.files.isSelectionEmpty()) {
                if (preferable != null && preferable.getModel().getSize() > 0) {
                    preferable.setSelectedIndex(0);
                    return preferable;
                }
                if (this.files.getModel().getSize() > 0) {
                    this.files.setSelectedIndex(0);
                    return this.files;
                }
                this.toolWindows.setSelectedIndex(0);
                return this.toolWindows;
            }
            return this.toolWindows.isSelectionEmpty() ? this.files : this.toolWindows;
        }

        void navigate() {
            final Object[] values = this.getSelectedList().getSelectedValues();
            this.myPopup.closeOk(null);
            if (values.length > 0 && values[0] instanceof ToolWindow) {
                ((ToolWindow)values[0]).activate(null, true, true);
            } else {
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(new Runnable(){

                    @Override
                    public void run() {
                        FileEditorManagerImpl manager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)SwitcherPanel.this.project);
                        for (Object value : values) {
                            if (!(value instanceof FileInfo)) continue;
                            FileInfo info = (FileInfo)((Object)value);
                            if (info.second != null) {
                                EditorWindow wnd = SwitcherPanel.findAppropriateWindow(info);
                                if (wnd == null) continue;
                                manager.openFileImpl2(wnd, (VirtualFile)info.first, true);
                                manager.addSelectionRecord((VirtualFile)info.first, wnd);
                                continue;
                            }
                            manager.openFile((VirtualFile)info.first, true, true);
                        }
                    }
                });
            }
        }

        @Nullable
        private static EditorWindow findAppropriateWindow(FileInfo info) {
            if (info.second == null) {
                return null;
            }
            Object[] windows = ((EditorWindow)info.second).getOwner().getWindows();
            return ArrayUtil.contains((Object)info.second, (Object[])windows) ? (EditorWindow)info.second : (windows.length > 0 ? windows[0] : null);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JList list;
            int index;
            if (this.mouseMovedFirstTime) {
                this.mouseMovedFirstTime = false;
                return;
            }
            Object source = e.getSource();
            boolean changed = false;
            if (source instanceof JList && 0 <= (index = (list = (JList)source).locationToIndex(e.getPoint())) && index < list.getModel().getSize()) {
                this.mouseMoveSrc = list;
                this.mouseMoveListIndex = index;
                changed = true;
            }
            if (!changed) {
                this.mouseMoveSrc = null;
                this.mouseMoveListIndex = -1;
            }
            this.repaintLists();
        }

        private void repaintLists() {
            this.toolWindows.repaint();
            this.files.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseMoveSrc = null;
            this.mouseMoveListIndex = -1;
            this.repaintLists();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        public boolean isAutoHide() {
            return !this.myPinned;
        }

        public boolean isPinnedMode() {
            return this.myPinned;
        }

        private class SwitcherLayouter
        extends BorderLayout {
            private Rectangle sBounds;
            private Rectangle tBounds;
            private Rectangle fBounds;
            private Rectangle dBounds;

            private SwitcherLayouter() {
            }

            @Override
            public void layoutContainer(Container target) {
                JScrollPane filesPane;
                JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)((Object)SwitcherPanel.this.files));
                Object object = filesPane = scrollPane != null ? scrollPane : SwitcherPanel.this.files;
                if (this.sBounds == null) {
                    super.layoutContainer(target);
                    this.sBounds = SwitcherPanel.this.separator.getBounds();
                    this.tBounds = SwitcherPanel.this.toolWindows.getBounds();
                    this.fBounds = filesPane.getBounds();
                    this.dBounds = SwitcherPanel.this.descriptions.getBounds();
                } else {
                    int h = target.getHeight();
                    int w = target.getWidth();
                    this.sBounds.height = h - this.dBounds.height;
                    this.tBounds.height = h - this.dBounds.height;
                    this.fBounds.height = h - this.dBounds.height;
                    this.fBounds.width = w - this.sBounds.width - this.tBounds.width;
                    this.dBounds.width = w;
                    this.dBounds.y = h - this.dBounds.height;
                    SwitcherPanel.this.separator.setBounds(this.sBounds);
                    SwitcherPanel.this.toolWindows.setBounds(this.tBounds);
                    filesPane.setBounds(this.fBounds);
                    SwitcherPanel.this.descriptions.setBounds(this.dBounds);
                }
            }
        }

        private class SwitcherSpeedSearch
        extends SpeedSearchBase<SwitcherPanel>
        implements PropertyChangeListener {
            private Object[] myElements;

            public SwitcherSpeedSearch() {
                super(SwitcherPanel.this);
                this.addChangeListener(this);
                this.setComparator(new SpeedSearchComparator(false, true));
            }

            @Override
            protected void processKeyEvent(final KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 37 || keyCode == 39) {
                    return;
                }
                if (keyCode == 10 && SwitcherPanel.this.files.getModel().getSize() + SwitcherPanel.this.toolWindows.getModel().getSize() == 0) {
                    AnAction gotoAction = ActionManager.getInstance().getAction("GotoClass");
                    if (gotoAction == null) {
                        gotoAction = ActionManager.getInstance().getAction("GotoFile");
                    }
                    if (gotoAction != null) {
                        final String search = SwitcherPanel.this.mySpeedSearch.getEnteredPrefix();
                        SwitcherPanel.this.myPopup.cancel();
                        final AnAction action = gotoAction;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

                                    public void consume(final DataContext context) {
                                        DataContext dataContext = new DataContext(){

                                            @Nullable
                                            public Object getData(@NonNls String dataId) {
                                                if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
                                                    return search;
                                                }
                                                return context.getData(dataId);
                                            }
                                        };
                                        AnActionEvent event = new AnActionEvent((InputEvent)e, dataContext, "EditorPopup", new PresentationFactory().getPresentation(action), ActionManager.getInstance(), 0);
                                        action.actionPerformed(event);
                                    }
                                });
                            }
                        });
                        return;
                    }
                }
                super.processKeyEvent(e);
            }

            @Override
            protected int getSelectedIndex() {
                return SwitcherPanel.this.isFilesSelected() ? SwitcherPanel.this.files.getSelectedIndex() : SwitcherPanel.this.files.getModel().getSize() + SwitcherPanel.this.toolWindows.getSelectedIndex();
            }

            @Override
            protected Object[] getAllElements() {
                SwitcherPanel switcher = SwitcherPanel.this;
                ListModel filesModel = switcher.files.getModel();
                Object[] files = new Object[filesModel.getSize()];
                for (int i = 0; i < files.length; ++i) {
                    files[i] = filesModel.getElementAt(i);
                }
                ListModel twModel = switcher.toolWindows.getModel();
                Object[] toolWindows = new Object[twModel.getSize()];
                for (int i = 0; i < toolWindows.length; ++i) {
                    toolWindows[i] = twModel.getElementAt(i);
                }
                this.myElements = new Object[files.length + toolWindows.length];
                System.arraycopy(files, 0, this.myElements, 0, files.length);
                System.arraycopy(toolWindows, 0, this.myElements, files.length, toolWindows.length);
                return this.myElements;
            }

            @Override
            protected String getElementText(Object element) {
                if (element instanceof ToolWindow) {
                    return SwitcherPanel.this.ids.get(element);
                }
                if (element instanceof FileInfo) {
                    VirtualFile file = (VirtualFile)((FileInfo)((Object)element)).getFirst();
                    return file instanceof VirtualFilePathWrapper ? ((VirtualFilePathWrapper)file).getPresentablePath() : file.getName();
                }
                return "";
            }

            @Override
            protected void selectElement(Object element, String selectedText) {
                if (element instanceof FileInfo) {
                    if (!SwitcherPanel.this.toolWindows.isSelectionEmpty()) {
                        SwitcherPanel.this.toolWindows.clearSelection();
                    }
                    SwitcherPanel.this.files.setSelectedValue(element, false);
                } else {
                    if (!SwitcherPanel.this.files.isSelectionEmpty()) {
                        SwitcherPanel.this.files.clearSelection();
                    }
                    SwitcherPanel.this.toolWindows.setSelectedValue(element, false);
                }
            }

            @Override
            @Nullable
            protected Object findElement(String s) {
                List<SpeedSearchObjectWithWeight> elements = SpeedSearchObjectWithWeight.findElement(s, this);
                return elements.isEmpty() ? null : elements.get((int)0).node;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MyList list = SwitcherPanel.this.getSelectedList();
                Object value = list.getSelectedValue();
                if (SwitcherPanel.this.project.isDisposed()) {
                    SwitcherPanel.this.myPopup.cancel();
                    return;
                }
                ((NameFilteringListModel)SwitcherPanel.this.files.getModel()).refilter();
                ((NameFilteringListModel)SwitcherPanel.this.toolWindows.getModel()).refilter();
                if (SwitcherPanel.this.files.getModel().getSize() + SwitcherPanel.this.toolWindows.getModel().getSize() == 0) {
                    SwitcherPanel.this.toolWindows.getEmptyText().setText("");
                    SwitcherPanel.this.files.getEmptyText().setText("Press 'Enter' to search in Project");
                } else {
                    SwitcherPanel.this.files.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
                    SwitcherPanel.this.toolWindows.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
                }
                SwitcherPanel.this.files.repaint();
                SwitcherPanel.this.toolWindows.repaint();
                SwitcherPanel.this.getSelectedList(list).setSelectedValue(value, true);
            }
        }
    }
}

