/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public abstract class SplitAction
extends AnAction
implements DumbAware {
    private final int myOrientation;
    private final boolean myCloseSource;

    protected SplitAction(int orientation) {
        this(orientation, false);
    }

    protected SplitAction(int orientation, boolean closeSource) {
        this.myOrientation = orientation;
        this.myCloseSource = closeSource;
    }

    public void actionPerformed(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
        EditorWindow window = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        VirtualFile file = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        fileEditorManager.createSplitter(this.myOrientation, window);
        if (this.myCloseSource && window != null && file != null) {
            window.closeFile(file, false, false);
        }
    }

    public void update(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        EditorWindow window = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        int minimum = this.myCloseSource ? 2 : 1;
        boolean enabled = project != null && window != null && window.getTabCount() >= minimum;
        event.getPresentation().setEnabled(enabled);
    }
}

