/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.IdeConfigurablesGroup;
import com.intellij.openapi.options.ex.ProjectConfigurablesGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import javax.swing.SwingUtilities;

public class ShowSettingsAction
extends AnAction
implements DumbAware {
    public ShowSettingsAction() {
        super(CommonBundle.settingsAction(), CommonBundle.settingsActionDescription(), AllIcons.General.Settings);
    }

    public void update(AnActionEvent e) {
        if (SystemInfo.isMac && e.getPlace().equals("MainMenu")) {
            e.getPresentation().setVisible(false);
        }
        if (e.getPlace().equals("WelcomeScreen")) {
            e.getPresentation().setText(CommonBundle.settingsTitle());
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        final long startTime = System.nanoTime();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long endTime = System.nanoTime();
                if (ApplicationManagerEx.getApplicationEx().isInternal()) {
                    System.out.println("Displaying settings dialog took " + (endTime - startTime) / 1000000L + " ms");
                }
            }
        });
        ShowSettingsUtil.getInstance().showSettingsDialog(project, new ConfigurableGroup[]{new ProjectConfigurablesGroup(project), new IdeConfigurablesGroup()});
    }
}

