/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class OpenProjectFileChooserDescriptor
extends FileChooserDescriptor {
    private static final Icon ourProjectIcon = IconLoader.getIcon((String)ApplicationInfoEx.getInstanceEx().getSmallIconUrl());

    public OpenProjectFileChooserDescriptor(boolean chooseFiles) {
        super(chooseFiles, true, chooseFiles, chooseFiles, false, false);
    }

    public boolean isFileSelectable(VirtualFile file) {
        if (file == null) {
            return false;
        }
        return OpenProjectFileChooserDescriptor.isProjectDirectory(file) || OpenProjectFileChooserDescriptor.isProjectFile(file);
    }

    public Icon getIcon(VirtualFile file) {
        if (OpenProjectFileChooserDescriptor.isProjectDirectory(file)) {
            return OpenProjectFileChooserDescriptor.dressIcon((VirtualFile)file, (Icon)ourProjectIcon);
        }
        Icon icon = OpenProjectFileChooserDescriptor.getImporterIcon(file);
        if (icon != null) {
            return OpenProjectFileChooserDescriptor.dressIcon((VirtualFile)file, (Icon)icon);
        }
        return super.getIcon(file);
    }

    @Nullable
    private static Icon getImporterIcon(VirtualFile virtualFile) {
        ProjectOpenProcessor provider = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile);
        if (provider != null) {
            return virtualFile.isDirectory() && provider.lookForProjectsInDirectory() ? AllIcons.Nodes.IdeaModule : provider.getIcon(virtualFile);
        }
        return null;
    }

    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        if (!showHiddenFiles && FileElement.isFileHidden((VirtualFile)file)) {
            return false;
        }
        return OpenProjectFileChooserDescriptor.isProjectFile(file) || super.isFileVisible(file, showHiddenFiles) && file.isDirectory();
    }

    public static boolean isProjectFile(VirtualFile file) {
        if (OpenProjectFileChooserDescriptor.isIprFile(file)) {
            return true;
        }
        ProjectOpenProcessor importProvider = ProjectOpenProcessor.getImportProvider((VirtualFile)file);
        return importProvider != null;
    }

    private static boolean isIprFile(VirtualFile file) {
        return !file.isDirectory() && file.getName().toLowerCase().endsWith(".ipr");
    }

    private static boolean isProjectDirectory(VirtualFile virtualFile) {
        if (virtualFile.getParent() == null) {
            return false;
        }
        return virtualFile.isDirectory() && virtualFile.isValid() && virtualFile.findChild(".idea") != null;
    }
}

