/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenProcessorBase;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class OpenProjectAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        ProjectOpenProcessor[] openProcessors;
        OpenProjectFileChooserDescriptor descriptor = new OpenProjectFileChooserDescriptor(true);
        descriptor.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        extensions.add(".ipr");
        for (ProjectOpenProcessor openProcessor : openProcessors = (ProjectOpenProcessor[])Extensions.getExtensions((ExtensionPointName)ProjectOpenProcessor.EXTENSION_POINT_NAME)) {
            String[] supportedExtensions;
            if (!(openProcessor instanceof ProjectOpenProcessorBase) || (supportedExtensions = ((ProjectOpenProcessorBase)openProcessor).getSupportedExtensions()) == null) continue;
            Collections.addAll(extensions, supportedExtensions);
        }
        descriptor.setDescription(IdeBundle.message((String)"filter.project.files", (Object[])new Object[]{StringUtil.join(extensions, (String)", ")}));
        VirtualFile userHomeDir = null;
        if (SystemInfo.isUnix) {
            userHomeDir = VfsUtil.getUserHomeDir();
        }
        descriptor.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, Boolean.TRUE);
        final Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)userHomeDir, (Consumer)new Consumer<List<VirtualFile>>(){

            public void consume(List<VirtualFile> files) {
                if (files.size() == 1) {
                    ProjectUtil.openOrImport(files.get(0).getPath(), project, false);
                }
            }
        });
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabledAndVisible("WelcomeScreen".equals(e.getPlace()));
    }
}

