/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.Consumer;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        final boolean showFiles = project != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
        final OpenProjectFileChooserDescriptor descriptor = new OpenProjectFileChooserDescriptor(true){

            @Override
            public boolean isFileSelectable(VirtualFile file) {
                if (super.isFileSelectable(file)) {
                    return true;
                }
                if (file.isDirectory()) {
                    return false;
                }
                return showFiles && !FileElement.isArchive((VirtualFile)file);
            }

            @Override
            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!file.isDirectory() && this.isFileSelectable(file)) {
                    return showHiddenFiles || !FileElement.isFileHidden((VirtualFile)file);
                }
                return super.isFileVisible(file, showHiddenFiles);
            }

            public boolean isChooseMultiple() {
                return showFiles;
            }
        };
        descriptor.setTitle(showFiles ? "Open File or Project" : "Open Project");
        VirtualFile userHomeDir = null;
        if (SystemInfo.isUnix) {
            userHomeDir = VfsUtil.getUserHomeDir();
        }
        descriptor.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, Boolean.TRUE);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)userHomeDir, (Consumer)new Consumer<List<VirtualFile>>(){

            public void consume(List<VirtualFile> files) {
                for (VirtualFile file : files) {
                    if (descriptor.isFileSelectable(file)) continue;
                    Messages.showInfoMessage((Project)project, (String)(file.getPresentableUrl() + " contains no " + ApplicationNamesInfo.getInstance().getFullProductName() + " project"), (String)"Cannot Open Project");
                    return;
                }
                OpenFileAction.doOpenFile(project, files);
            }
        });
    }

    private static void doOpenFile(@Nullable Project project, @NotNull List<VirtualFile> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/actions/OpenFileAction", "doOpenFile"));
        }
        for (VirtualFile file : result) {
            Project openedProject;
            if (file.isDirectory()) {
                openedProject = ProjectAttachProcessor.canAttachToProject() ? PlatformProjectOpenProcessor.doOpenProject(file, project, false, -1, null, false) : ProjectUtil.openOrImport(file.getPath(), project, false);
                FileChooserUtil.setLastOpenedFile(openedProject, file);
                return;
            }
            if (OpenProjectFileChooserDescriptor.isProjectFile(file) && (project == null || !file.equals(project.getProjectFile())) && (openedProject = ProjectUtil.openOrImport(file.getPath(), project, false)) != null) {
                FileChooserUtil.setLastOpenedFile(openedProject, file);
                return;
            }
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate(file, project);
            if (type == null) {
                return;
            }
            if (project != null) {
                OpenFileAction.openFile(file, project);
                continue;
            }
            PlatformProjectOpenProcessor processor = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (processor == null) continue;
            processor.doOpenProject(file, null, false);
        }
    }

    public static void openFile(String filePath, Project project) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file != null && file.isValid()) {
            OpenFileAction.openFile(file, project);
        }
    }

    public static void openFile(VirtualFile virtualFile, Project project) {
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        if (editorProviderManager.getProviders(project, virtualFile).length == 0) {
            Messages.showMessageDialog((Project)project, (String)IdeBundle.message((String)"error.files.of.this.type.cannot.be.opened", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), (String)IdeBundle.message((String)"title.cannot.open.file", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }
}

