/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.Nullable;

abstract class OccurenceNavigatorActionBase
extends AnAction
implements DumbAware {
    OccurenceNavigatorActionBase() {
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(e.getDataContext());
        if (navigator == null) {
            return;
        }
        if (!this.hasOccurenceToGo(navigator)) {
            return;
        }
        OccurenceNavigator.OccurenceInfo occurenceInfo = this.go(navigator);
        if (occurenceInfo == null) {
            return;
        }
        Navigatable descriptor = occurenceInfo.getNavigateable();
        if (descriptor != null && descriptor.canNavigate()) {
            descriptor.navigate(false);
        }
        if (occurenceInfo.getOccurenceNumber() == -1 || occurenceInfo.getOccurencesCount() == -1) {
            return;
        }
        WindowManager.getInstance().getStatusBar(project).setInfo(IdeBundle.message((String)"message.occurrence.N.of.M", (Object[])new Object[]{occurenceInfo.getOccurenceNumber(), occurenceInfo.getOccurencesCount()}));
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(!"MainMenu".equals(event.getPlace()));
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(event.getDataContext());
        if (navigator == null) {
            presentation.setEnabled(false);
            presentation.setVisible(!"MainMenu".equals(event.getPlace()));
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(this.hasOccurenceToGo(navigator));
        presentation.setText(this.getDescription(navigator));
    }

    protected abstract OccurenceNavigator.OccurenceInfo go(OccurenceNavigator var1);

    protected abstract boolean hasOccurenceToGo(OccurenceNavigator var1);

    protected abstract String getDescription(OccurenceNavigator var1);

    @Nullable
    protected OccurenceNavigator getNavigator(DataContext dataContext) {
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(dataContext, false);
        if (contentManager != null) {
            Content content = contentManager.getSelectedContent();
            if (content == null) {
                return null;
            }
            JComponent component = content.getComponent();
            return OccurenceNavigatorActionBase.findNavigator(component);
        }
        return (OccurenceNavigator)OccurenceNavigatorActionBase.getOccurenceNavigatorFromContext(dataContext);
    }

    @Nullable
    private static OccurenceNavigator findNavigator(JComponent parent) {
        LinkedList<JComponent> queue = new LinkedList<JComponent>();
        queue.addLast(parent);
        while (!queue.isEmpty()) {
            JComponent component = (JComponent)queue.removeFirst();
            if (component instanceof OccurenceNavigator) {
                return (OccurenceNavigator)component;
            }
            if (component instanceof JTabbedPane) {
                JComponent selectedComponent = (JComponent)((JTabbedPane)component).getSelectedComponent();
                if (selectedComponent == null) continue;
                queue.addLast(selectedComponent);
                continue;
            }
            if (component == null) continue;
            for (int i = 0; i < component.getComponentCount(); ++i) {
                Component child = component.getComponent(i);
                if (!(child instanceof JComponent)) continue;
                queue.addLast((JComponent)child);
            }
        }
        return null;
    }

    @Nullable
    private static Component getOccurenceNavigatorFromContext(DataContext dataContext) {
        Project project;
        Window window = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (window != null) {
            Component component;
            for (Component c = component = window.getFocusOwner(); c != null; c = c.getParent()) {
                if (!(c instanceof OccurenceNavigator)) continue;
                return c;
            }
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return null;
        }
        ToolWindowManagerEx mgr = ToolWindowManagerEx.getInstanceEx(project);
        String id = mgr.getLastActiveToolWindowId(new Condition<JComponent>(){

            public boolean value(JComponent component) {
                return OccurenceNavigatorActionBase.findNavigator(component) != null;
            }
        });
        if (id == null) {
            return null;
        }
        return (Component)OccurenceNavigatorActionBase.findNavigator(mgr.getToolWindow(id).getComponent());
    }
}

