/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoRelatedFileAction
extends AnAction {
    public void update(AnActionEvent e) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(e.getDataContext());
        e.getPresentation().setEnabled(element != null || file != null);
    }

    public void actionPerformed(AnActionEvent e) {
        List<GotoRelatedItem> items;
        DataContext dataContext = e.getDataContext();
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element == null && file == null) {
            return;
        }
        List<GotoRelatedItem> list = items = element == null ? GotoRelatedFileAction.getItems(file, editor, dataContext) : GotoRelatedFileAction.getItems(element, dataContext);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1 && items.get(0).getElement() != null) {
            items.get(0).navigate();
            return;
        }
        GotoRelatedFileAction.createPopup(items, "Choose Target").showInBestPositionFor(dataContext);
    }

    public static JBPopup createPopup(List<? extends GotoRelatedItem> items, String title) {
        Object[] elements = new Object[items.size()];
        final HashMap<PsiElement, GotoRelatedItem> itemsMap = new HashMap<PsiElement, GotoRelatedItem>();
        for (int i = 0; i < items.size(); ++i) {
            GotoRelatedItem item = items.get(i);
            elements[i] = item.getElement() != null ? item.getElement() : item;
            itemsMap.put(item.getElement(), item);
        }
        return GotoRelatedFileAction.getPsiElementPopup(elements, itemsMap, title, new Processor<Object>(){

            public boolean process(Object element) {
                if (element instanceof PsiElement) {
                    ((GotoRelatedItem)itemsMap.get(element)).navigate();
                } else {
                    ((GotoRelatedItem)element).navigate();
                }
                return true;
            }
        });
    }

    private static JBPopup getPsiElementPopup(Object[] elements, final Map<PsiElement, GotoRelatedItem> itemsMap, String title, final Processor<Object> processor) {
        final Ref hasMnemonic = Ref.create((Object)false);
        final DefaultPsiElementCellRenderer renderer = new DefaultPsiElementCellRenderer(){
            {
                this.setFocusBorderEnabled(false);
            }

            @Override
            public String getElementText(PsiElement element) {
                String customName = ((GotoRelatedItem)itemsMap.get(element)).getCustomName();
                return customName != null ? customName : super.getElementText(element);
            }

            @Override
            protected Icon getIcon(PsiElement element) {
                Icon customIcon = ((GotoRelatedItem)itemsMap.get(element)).getCustomIcon();
                return customIcon != null ? customIcon : super.getIcon(element);
            }

            @Override
            public String getContainerText(PsiElement element, String name) {
                String customContainerName = ((GotoRelatedItem)itemsMap.get(element)).getCustomContainerName();
                if (customContainerName != null) {
                    return customContainerName;
                }
                PsiFile file = element.getContainingFile();
                return file != null && !this.getElementText(element).equals(file.getName()) ? "(" + file.getName() + ")" : null;
            }

            @Override
            protected DefaultListCellRenderer getRightCellRenderer(Object value) {
                return null;
            }

            @Override
            protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list, Object value, int index, boolean selected, boolean hasFocus) {
                GotoRelatedItem item = (GotoRelatedItem)value;
                Color color = list.getForeground();
                SimpleTextAttributes nameAttributes = new SimpleTextAttributes(0, color);
                String name = item.getCustomName();
                if (name == null) {
                    return false;
                }
                renderer.append(name, nameAttributes);
                renderer.setIcon(item.getCustomIcon());
                return true;
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel component = (JPanel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!((Boolean)hasMnemonic.get()).booleanValue()) {
                    return component;
                }
                JPanel panelWithMnemonic = new JPanel(new BorderLayout());
                int mnemonic = GotoRelatedFileAction.getMnemonic(value, itemsMap);
                JLabel label = new JLabel("");
                if (mnemonic != -1) {
                    label.setText(mnemonic + ".");
                    label.setDisplayedMnemonicIndex(0);
                }
                label.setPreferredSize(new JLabel("8.").getPreferredSize());
                JComponent leftRenderer = (JComponent)component.getComponents()[0];
                component.remove(leftRenderer);
                panelWithMnemonic.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
                panelWithMnemonic.setBackground(leftRenderer.getBackground());
                label.setBackground(leftRenderer.getBackground());
                panelWithMnemonic.add((Component)label, "West");
                panelWithMnemonic.add((Component)leftRenderer, "Center");
                component.add(panelWithMnemonic);
                return component;
            }
        };
        final ListPopupImpl popup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<Object>(title, Arrays.asList(elements)){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public String getIndexedString(Object value) {
                if (value instanceof GotoRelatedItem) {
                    return ((GotoRelatedItem)value).getCustomName();
                }
                PsiElement element = (PsiElement)value;
                return renderer.getElementText(element) + " " + renderer.getContainerText(element, (String)null);
            }

            public PopupStep onChosen(Object selectedValue, boolean finalChoice) {
                processor.process(selectedValue);
                return super.onChosen(selectedValue, finalChoice);
            }
        }){};
        popup.getList().setCellRenderer(new PopupListElementRenderer(popup){
            Map<Object, String> separators;
            {
                super(x0);
                this.separators = new HashMap<Object, String>();
                ListModel model = popup.getList().getModel();
                String current = null;
                boolean hasTitle = false;
                for (int i = 0; i < model.getSize(); ++i) {
                    Object element = model.getElementAt(i);
                    GotoRelatedItem item = (GotoRelatedItem)itemsMap.get(element);
                    if (item == null || StringUtil.equals(current, (CharSequence)item.getGroup())) continue;
                    current = item.getGroup();
                    this.separators.put(element, current);
                    if (hasTitle || StringUtil.isEmpty((String)current)) continue;
                    hasTitle = true;
                }
                if (!hasTitle) {
                    this.separators.remove(model.getElementAt(0));
                }
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                String separator = this.separators.get(value);
                if (separator != null) {
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.add(component, "Center");
                    SeparatorWithText sep = new SeparatorWithText(){

                        protected void paintComponent(Graphics g) {
                            g.setColor((Color)new JBColor(Color.WHITE, UIUtil.getSeparatorColor()));
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            super.paintComponent(g);
                        }
                    };
                    sep.setCaption(separator);
                    panel.add((Component)sep, "North");
                    return panel;
                }
                return component;
            }
        });
        popup.setMinimumSize(new Dimension(200, -1));
        for (Object item : elements) {
            int mnemonic = GotoRelatedFileAction.getMnemonic(item, itemsMap);
            if (mnemonic == -1) continue;
            Action action = GotoRelatedFileAction.createNumberAction(mnemonic, popup, itemsMap, processor);
            popup.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke(String.valueOf(mnemonic)), action);
            popup.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke("NUMPAD" + String.valueOf(mnemonic)), action);
            hasMnemonic.set((Object)true);
        }
        return popup;
    }

    @NotNull
    public static List<GotoRelatedItem> getItems(@NotNull PsiFile psiFile, @Nullable Editor editor, @Nullable DataContext dataContext) {
        PsiElement element;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/GotoRelatedFileAction", "getItems"));
        }
        PsiFile contextElement = psiFile;
        if (editor != null && (element = psiFile.findElementAt(editor.getCaretModel().getOffset())) != null) {
            contextElement = element;
        }
        List<GotoRelatedItem> list = GotoRelatedFileAction.getItems((PsiElement)contextElement, dataContext);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoRelatedFileAction", "getItems"));
        }
        return list;
    }

    @NotNull
    public static List<GotoRelatedItem> getItems(@NotNull PsiElement contextElement, @Nullable DataContext dataContext) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/GotoRelatedFileAction", "getItems"));
        }
        LinkedHashSet items = ContainerUtil.newLinkedHashSet();
        for (GotoRelatedProvider provider : (GotoRelatedProvider[])Extensions.getExtensions((ExtensionPointName)GotoRelatedProvider.EP_NAME)) {
            items.addAll(provider.getItems(contextElement));
            if (dataContext == null) continue;
            items.addAll(provider.getItems(dataContext));
        }
        GotoRelatedFileAction.sortByGroupNames(items);
        ArrayList<GotoRelatedItem> arrayList = new ArrayList<GotoRelatedItem>(items);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoRelatedFileAction", "getItems"));
        }
        return arrayList;
    }

    private static void sortByGroupNames(Set<GotoRelatedItem> items) {
        HashMap map = new HashMap();
        for (GotoRelatedItem item : items) {
            String key = item.getGroup();
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(item);
        }
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return StringUtil.isEmpty((String)o1) ? 1 : (StringUtil.isEmpty((String)o2) ? -1 : o1.compareTo(o2));
            }
        });
        items.clear();
        for (String key : keys) {
            items.addAll((Collection)map.get(key));
        }
    }

    private static Action createNumberAction(final int mnemonic, final ListPopupImpl listPopup, final Map<PsiElement, GotoRelatedItem> itemsMap, final Processor<Object> processor) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (final Object item : listPopup.getListStep().getValues()) {
                    if (GotoRelatedFileAction.getMnemonic(item, itemsMap) != mnemonic) continue;
                    listPopup.setFinalRunnable(new Runnable(){

                        @Override
                        public void run() {
                            processor.process(item);
                        }
                    });
                    listPopup.closeOk(null);
                }
            }
        };
    }

    private static int getMnemonic(Object item, Map<PsiElement, GotoRelatedItem> itemsMap) {
        return (item instanceof GotoRelatedItem ? (GotoRelatedItem)item : itemsMap.get((PsiElement)item)).getMnemonic();
    }
}

