/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameLanguageFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoClassAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        if (!DumbService.getInstance((Project)project).isDumb()) {
            super.actionPerformed(e);
        } else {
            DumbService.getInstance((Project)project).showDumbModeNotification("Goto Class action is not available until indices are built, using Goto File instead");
            ActionManager.getInstance().tryToExecute(ActionManager.getInstance().getAction("GotoFile"), ActionCommand.getInputEvent("GotoFile"), (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT), e.getPlace(), true);
        }
    }

    @Override
    public void gotoActionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.class");
        final GotoClassModel2 model = new GotoClassModel2(project);
        this.showNavigationPopup(e, model, new GotoActionBase.GotoActionCallback<Language>(){

            @Override
            protected ChooseByNameFilter<Language> createFilter(@NotNull ChooseByNamePopup popup) {
                if (popup == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/GotoClassAction$1", "createFilter"));
                }
                return new ChooseByNameLanguageFilter(popup, model, GotoClassSymbolConfiguration.getInstance(project), project);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void elementChosen(ChooseByNamePopup popup, Object element) {
                AccessToken token = ReadAction.start();
                try {
                    if (element instanceof PsiElement) {
                        OpenFileDescriptor n;
                        PsiElement psiElement = GotoClassAction.getElement((PsiElement)element, popup);
                        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
                        if (popup.getLinePosition() != -1 && file != null && (n = new OpenFileDescriptor(project, file, popup.getLinePosition(), popup.getColumnPosition()).setUseCurrentWindow(popup.isOpenInCurrentWindowRequested())).canNavigate()) {
                            n.navigate(true);
                            return;
                        }
                        if (psiElement != null && file != null && popup.getMemberPattern() != null) {
                            NavigationUtil.activateFileWithPsiElement(psiElement, !popup.isOpenInCurrentWindowRequested());
                            Navigatable member = GotoClassAction.findMember(popup.getMemberPattern(), psiElement, file);
                            if (member != null) {
                                member.navigate(true);
                            }
                        }
                        NavigationUtil.activateFileWithPsiElement(psiElement, !popup.isOpenInCurrentWindowRequested());
                    } else {
                        EditSourceUtil.navigate((NavigationItem)((NavigationItem)element), (boolean)true, (boolean)popup.isOpenInCurrentWindowRequested());
                    }
                }
                finally {
                    token.finish();
                }
            }
        }, "Classes matching pattern", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Navigatable findMember(String pattern, PsiElement psiElement, VirtualFile file) {
        PsiStructureViewFactory factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(psiElement.getLanguage());
        StructureViewBuilder builder = factory == null ? null : factory.getStructureViewBuilder(psiElement.getContainingFile());
        FileEditor[] editors = FileEditorManager.getInstance((Project)psiElement.getProject()).getEditors(file);
        if (builder == null || editors.length == 0) {
            return null;
        }
        StructureView view = builder.createStructureView(editors[0], psiElement.getProject());
        try {
            StructureViewTreeElement element = GotoClassAction.findElement(view.getTreeModel().getRoot(), psiElement, 4);
            if (element == null) {
                Navigatable navigatable = null;
                return navigatable;
            }
            MinusculeMatcher matcher = new MinusculeMatcher(pattern, NameUtil.MatchingCaseSensitivity.NONE);
            int max = Integer.MIN_VALUE;
            Object target = null;
            for (TreeElement treeElement : element.getChildren()) {
                int degree;
                String presentableText;
                if (!(treeElement instanceof StructureViewTreeElement)) continue;
                ItemPresentation presentation = treeElement.getPresentation();
                String string = presentableText = presentation == null ? null : presentation.getPresentableText();
                if (presentableText == null || (degree = matcher.matchingDegree(presentableText)) <= max) continue;
                max = degree;
                target = ((StructureViewTreeElement)treeElement).getValue();
            }
            Navigatable navigatable = target instanceof Navigatable ? (Navigatable)target : null;
            return navigatable;
        }
        finally {
            Disposer.dispose((Disposable)view);
        }
    }

    @Nullable
    private static StructureViewTreeElement findElement(StructureViewTreeElement node, PsiElement element, int hopes) {
        Object value = node.getValue();
        if (value instanceof PsiElement) {
            if (((PsiElement)value).isEquivalentTo(element)) {
                return node;
            }
            if (hopes != 0) {
                for (TreeElement child : node.getChildren()) {
                    StructureViewTreeElement e;
                    if (!(child instanceof StructureViewTreeElement) || (e = GotoClassAction.findElement((StructureViewTreeElement)child, element, hopes - 1)) == null) continue;
                    return e;
                }
            }
        }
        return null;
    }

    private static PsiElement getElement(@NotNull PsiElement element, ChooseByNamePopup popup) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/GotoClassAction", "getElement"));
        }
        String path = popup.getPathToAnonymous();
        if (path != null) {
            String[] classes = path.split("\\$");
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (String cls : classes) {
                if (cls.isEmpty()) continue;
                try {
                    indexes.add(Integer.parseInt(cls) - 1);
                }
                catch (Exception e) {
                    return element;
                }
            }
            PsiElement current = element;
            Iterator i$ = indexes.iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                PsiElement[] anonymousClasses = GotoClassAction.getAnonymousClasses(current);
                if (anonymousClasses.length > index) {
                    current = anonymousClasses[index];
                    continue;
                }
                return current;
            }
            return current;
        }
        return element;
    }

    @NotNull
    private static PsiElement[] getAnonymousClasses(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/GotoClassAction", "getAnonymousClasses"));
        }
        for (AnonymousElementProvider provider : (AnonymousElementProvider[])Extensions.getExtensions((ExtensionPointName)AnonymousElementProvider.EP_NAME)) {
            PsiElement[] elements = provider.getAnonymousElements(element);
            if (elements.length <= 0) continue;
            if (elements == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoClassAction", "getAnonymousClasses"));
            }
            return elements;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoClassAction", "getAnonymousClasses"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    protected boolean hasContributors(DataContext dataContext) {
        return ChooseByNameRegistry.getInstance().getClassModelContributors().length > 0;
    }
}

