/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateDirectoryOrPackageHandler
implements InputValidatorEx {
    @Nullable
    private final Project myProject;
    @NotNull
    private final PsiDirectory myDirectory;
    private final boolean myIsDirectory;
    @Nullable
    private PsiFileSystemItem myCreatedElement;
    @NotNull
    private final String myDelimiters;
    @Nullable
    private final Component myDialogParent;

    public CreateDirectoryOrPackageHandler(@Nullable Project project, @NotNull PsiDirectory directory, boolean isDirectory, @NotNull String delimiters) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/actions/CreateDirectoryOrPackageHandler", "<init>"));
        }
        if (delimiters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ide/actions/CreateDirectoryOrPackageHandler", "<init>"));
        }
        this(project, directory, isDirectory, delimiters, null);
    }

    public CreateDirectoryOrPackageHandler(@Nullable Project project, @NotNull PsiDirectory directory, boolean isDirectory, @NotNull String delimiters, @Nullable Component dialogParent) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/actions/CreateDirectoryOrPackageHandler", "<init>"));
        }
        if (delimiters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ide/actions/CreateDirectoryOrPackageHandler", "<init>"));
        }
        this.myCreatedElement = null;
        this.myProject = project;
        this.myDirectory = directory;
        this.myIsDirectory = isDirectory;
        this.myDelimiters = delimiters;
        this.myDialogParent = dialogParent;
    }

    public boolean checkInput(String inputString) {
        return true;
    }

    public String getErrorText(String inputString) {
        if (FileTypeManager.getInstance().isFileIgnored(inputString)) {
            return "Trying to create a " + (this.myIsDirectory ? "directory" : "package") + " with ignored name, result will not be visible";
        }
        if (!this.myIsDirectory && inputString.length() > 0 && !PsiDirectoryFactory.getInstance(this.myProject).isValidPackageName(inputString)) {
            return "Not a valid package name, it would be impossible to create a class inside";
        }
        return null;
    }

    public boolean canClose(String inputString) {
        String message;
        int ec;
        FileType fileType;
        String subDirName = inputString;
        if (subDirName.length() == 0) {
            this.showErrorDialog(IdeBundle.message((String)"error.name.should.be.specified", (Object[])new Object[0]));
            return false;
        }
        boolean multiCreation = StringUtil.containsAnyChar((String)subDirName, (String)this.myDelimiters);
        if (!multiCreation) {
            try {
                this.myDirectory.checkCreateSubdirectory(subDirName);
            }
            catch (IncorrectOperationException ex) {
                this.showErrorDialog(CreateElementActionBase.filterMessage((String)ex.getMessage()));
                return false;
            }
        }
        boolean createFile = false;
        if (StringUtil.countChars((CharSequence)subDirName, (char)'.') == 1 && Registry.is((String)"ide.suggest.file.when.creating.filename.like.directory") && (fileType = CreateDirectoryOrPackageHandler.findFileTypeBoundToName(subDirName)) != null && (ec = Messages.showYesNoDialog((Project)this.myProject, (String)(message = "The name you entered looks like a file name. Do you want to create a file named " + subDirName + " instead?"), (String)"File Name Detected", (String)"Yes, create file", (String)("No, create " + (this.myIsDirectory ? "directory" : "packages")), (Icon)fileType.getIcon())) == 0) {
            createFile = true;
        }
        this.doCreateElement(subDirName, createFile);
        return this.myCreatedElement != null;
    }

    @Nullable
    public static FileType findFileTypeBoundToName(String name) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(name);
        return fileType instanceof UnknownFileType ? null : fileType;
    }

    private void doCreateElement(final String subDirName, final boolean createFile) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                Runnable run = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LocalHistoryAction action = LocalHistoryAction.NULL;
                        try {
                            String dirPath = CreateDirectoryOrPackageHandler.this.myDirectory.getVirtualFile().getPresentableUrl();
                            String actionName = IdeBundle.message((String)"progress.creating.directory", (Object[])new Object[]{dirPath, File.separator, subDirName});
                            action = LocalHistory.getInstance().startAction(actionName);
                            if (createFile) {
                                CreateDirectoryOrPackageHandler.this.myCreatedElement = (PsiFileSystemItem)CreateDirectoryOrPackageHandler.this.myDirectory.createFile(subDirName);
                            } else {
                                CreateDirectoryOrPackageHandler.this.createDirectories(subDirName);
                            }
                        }
                        catch (IncorrectOperationException ex) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CreateDirectoryOrPackageHandler.this.showErrorDialog(CreateElementActionBase.filterMessage((String)ex.getMessage()));
                                }
                            });
                        }
                        finally {
                            action.finish();
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(run);
            }
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, command, createFile ? IdeBundle.message((String)"command.create.file", (Object[])new Object[0]) : (this.myIsDirectory ? IdeBundle.message((String)"command.create.directory", (Object[])new Object[0]) : IdeBundle.message((String)"command.create.package", (Object[])new Object[0])), null);
    }

    private void showErrorDialog(String message) {
        String title = CommonBundle.getErrorTitle();
        Icon icon = Messages.getErrorIcon();
        if (this.myDialogParent != null) {
            Messages.showMessageDialog((Component)this.myDialogParent, (String)message, (String)title, (Icon)icon);
        } else {
            Messages.showMessageDialog((Project)this.myProject, (String)message, (String)title, (Icon)icon);
        }
    }

    protected void createDirectories(String subDirName) {
        this.myCreatedElement = DirectoryUtil.createSubdirectories(subDirName, this.myDirectory, this.myDelimiters);
    }

    @Nullable
    public PsiFileSystemItem getCreatedElement() {
        return this.myCreatedElement;
    }
}

