/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopyPathsAction
extends AnAction
implements DumbAware {
    public CopyPathsAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Collection<VirtualFile> files = CopyPathsAction.getFiles(e);
        if (files.isEmpty()) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CopyPathsAction.getPaths(files)));
    }

    private static String getPaths(Collection<VirtualFile> files) {
        StringBuilder buf = new StringBuilder(files.size() * 64);
        boolean first = true;
        for (VirtualFile file : files) {
            if (first) {
                first = false;
            } else {
                buf.append("\n");
            }
            buf.append(file.getPresentableUrl());
        }
        return buf.toString();
    }

    public void update(AnActionEvent event) {
        Collection<VirtualFile> files = CopyPathsAction.getFiles(event);
        Presentation presentation = event.getPresentation();
        boolean enabled = !files.isEmpty();
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        } else {
            presentation.setVisible(true);
        }
        presentation.setText(files.size() == 1 ? IdeBundle.message((String)"action.copy.path", (Object[])new Object[0]) : IdeBundle.message((String)"action.copy.paths", (Object[])new Object[0]));
    }

    @NotNull
    private static Collection<VirtualFile> getFiles(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        if (files == null || files.length == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CopyPathsAction", "getFiles"));
            }
            return list;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(files.length);
        for (VirtualFile file : files) {
            if (file instanceof LightVirtualFile) continue;
            result.add(file);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CopyPathsAction", "getFiles"));
        }
        return arrayList;
    }
}

