/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.OpenModuleSettingsAction;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableWithText;
import com.intellij.util.OpenSourceUtil;
import org.jetbrains.annotations.Nullable;

public abstract class BaseNavigateToSourceAction
extends AnAction
implements DumbAware {
    private final boolean myFocusEditor;

    protected BaseNavigateToSourceAction(boolean focusEditor) {
        this.myFocusEditor = focusEditor;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        OpenSourceUtil.navigate((boolean)this.myFocusEditor, (Navigatable[])this.getNavigatables(dataContext));
    }

    public void update(AnActionEvent event) {
        boolean enabled;
        DataContext dataContext = event.getDataContext();
        Navigatable target = this.getTarget(dataContext);
        boolean bl = enabled = target != null;
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            event.getPresentation().setVisible(enabled);
            if (!(this instanceof OpenModuleSettingsAction) && OpenModuleSettingsAction.isModuleInProjectViewPopup(event)) {
                event.getPresentation().setVisible(false);
                return;
            }
        } else {
            event.getPresentation().setEnabled(enabled);
        }
        if (target != null && target instanceof NavigatableWithText) {
            if (!this.myFocusEditor) {
                event.getPresentation().setVisible(false);
                return;
            }
            String navigateActionText = ((NavigatableWithText)target).getNavigateActionText(this.myFocusEditor);
            if (navigateActionText != null) {
                event.getPresentation().setText(navigateActionText);
            } else {
                event.getPresentation().setText(this.getTemplatePresentation().getText());
            }
        } else {
            event.getPresentation().setText(this.getTemplatePresentation().getText());
        }
    }

    @Nullable
    private Navigatable getTarget(DataContext dataContext) {
        if (!this.myFocusEditor && CommonDataKeys.EDITOR.getData(dataContext) != null) {
            return null;
        }
        Navigatable[] navigatables = this.getNavigatables(dataContext);
        if (navigatables != null) {
            for (Navigatable navigatable : navigatables) {
                if (!navigatable.canNavigate()) continue;
                return navigatable;
            }
        }
        return null;
    }

    @Nullable
    protected Navigatable[] getNavigatables(DataContext dataContext) {
        return (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(dataContext);
    }
}

