/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class ApplyIntentionAction
extends AnAction {
    private final HighlightInfo.IntentionActionDescriptor myDescriptor;
    private final Editor myEditor;
    private final PsiFile myFile;

    public ApplyIntentionAction(HighlightInfo.IntentionActionDescriptor descriptor, Editor editor, PsiFile file) {
        super(descriptor.getAction().getText());
        this.myDescriptor = descriptor;
        this.myEditor = editor;
        this.myFile = file;
    }

    public void actionPerformed(AnActionEvent e) {
        IntentionAction action = this.myDescriptor.getAction();
        ShowIntentionActionsHandler.chooseActionAndInvoke(this.myFile, this.myEditor, action, action.getText());
    }

    public String getName() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return ApplyIntentionAction.this.myDescriptor.getAction().getText();
            }
        });
    }

    @Nullable
    public static ApplyIntentionAction[] getAvailableIntentions(final Editor editor, final PsiFile file) {
        final ShowIntentionsPass.IntentionsInfo info = new ShowIntentionsPass.IntentionsInfo();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ShowIntentionsPass.getActionsToShow(editor, file, info, -1);
            }
        });
        if (info.isEmpty()) {
            return null;
        }
        ArrayList<HighlightInfo.IntentionActionDescriptor> actions = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        actions.addAll(info.errorFixesToShow);
        actions.addAll(info.inspectionFixesToShow);
        actions.addAll(info.intentionsToShow);
        ApplyIntentionAction[] result = new ApplyIntentionAction[actions.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ApplyIntentionAction((HighlightInfo.IntentionActionDescriptor)actions.get(i), editor, file);
        }
        return result;
    }
}

