/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.SizedIcon;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;

public class ActivateToolWindowAction
extends AnAction
implements DumbAware {
    private final String myToolWindowId;

    protected ActivateToolWindowAction(String toolWindowId, String text, Icon icon) {
        super(text, IdeBundle.message((String)"action.activate.tool.window", (Object[])new Object[]{toolWindowId}), icon);
        this.myToolWindowId = toolWindowId;
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDisposed()) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(this.myToolWindowId);
        presentation.setEnabled(toolWindow != null && toolWindow.isAvailable());
        presentation.setVisible(toolWindow != null);
        if (toolWindow != null) {
            Icon icon = toolWindow.getIcon();
            presentation.setIcon((Icon)(icon == null ? null : new SizedIcon(icon, icon.getIconHeight(), icon.getIconHeight())));
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        if (windowManager.isEditorComponentActive() || !this.myToolWindowId.equals(windowManager.getActiveToolWindowId())) {
            windowManager.getToolWindow(this.myToolWindowId).activate(null);
        } else {
            windowManager.getToolWindow(this.myToolWindowId).hide(null);
        }
    }

    public String getToolWindowId() {
        return this.myToolWindowId;
    }

    @NonNls
    public static String getActionIdForToolWindow(String id) {
        return "Activate" + id.replaceAll(" ", "") + "ToolWindow";
    }

    public static int getMnemonicForToolWindow(String id) {
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = activeKeymap.getShortcuts(ActivateToolWindowAction.getActionIdForToolWindow(id));
        for (int i = 0; i < shortcuts.length; ++i) {
            int keyCode;
            KeyStroke keyStroke;
            int modifiers;
            Shortcut shortcut = shortcuts[i];
            if (!(shortcut instanceof KeyboardShortcut) || (modifiers = (keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke()).getModifiers()) != 520 && modifiers != 8 && modifiers != 512 && modifiers != 260 && modifiers != 4 && modifiers != 256 || 48 > (keyCode = keyStroke.getKeyCode()) || keyCode > 57) continue;
            char c = (char)(48 + keyCode - 48);
            return c;
        }
        return -1;
    }
}

