/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ReflectionUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SwingCleanuper
implements ApplicationComponent {
    private final Alarm myAlarm = new Alarm();

    SwingCleanuper(ProjectManager projectManager) {
        projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(Project project) {
                SwingCleanuper.this.myAlarm.cancelAllRequests();
            }

            public void projectClosed(Project project) {
                SwingCleanuper.this.myAlarm.cancelAllRequests();
                SwingCleanuper.this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        Application app;
                        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                        IdeFrameImpl frame = window instanceof IdeFrameImpl ? (IdeFrameImpl)window : (IdeFrameImpl)SwingUtilities.getAncestorOfClass(IdeFrameImpl.class, window);
                        if (frame != null && (app = ApplicationManager.getApplication()) != null && app.isActive()) {
                            ((JComponent)frame.getStatusBar()).requestFocus();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingCleanuper.resetStaticField(KeyboardFocusManager.class, "newFocusOwner");
                                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                SwingCleanuper.resetField(focusManager, Component.class, "realOppositeComponent");
                                SwingCleanuper.resetField(focusManager, Window.class, "realOppositeWindow");
                                try {
                                    Object helperObject = ReflectionUtil.getField(BasicPopupMenuUI.class, null, Object.class, (String)"menuKeyboardHelper");
                                    if (null != helperObject) {
                                        SwingCleanuper.resetField(helperObject, Component.class, "lastFocused");
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    Field recognizerField = TransferHandler.class.getDeclaredField("recognizer");
                                    recognizerField.setAccessible(true);
                                    Object recognizerObject = recognizerField.get(null);
                                    if (recognizerObject != null) {
                                        Method setComponentMethod = DragGestureRecognizer.class.getDeclaredMethod("setComponent", Component.class);
                                        setComponentMethod.invoke(recognizerObject, new Object[]{null});
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    SwingCleanuper.fixJTextComponentMemoryLeak();
                                }
                                catch (NoSuchFieldException e) {
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                focusManager.setGlobalCurrentFocusCycleRoot(null);
                                try {
                                    Method m = KeyboardFocusManager.class.getDeclaredMethod("setGlobalFocusOwner", Component.class);
                                    m.setAccessible(true);
                                    m.invoke((Object)focusManager, new Object[]{null});
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                SwingCleanuper.resetStaticField(KeyboardFocusManager.class, "newFocusOwner");
                                SwingCleanuper.resetStaticField(KeyboardFocusManager.class, "permanentFocusOwner");
                                SwingCleanuper.resetStaticField(KeyboardFocusManager.class, "currentFocusCycleRoot");
                            }
                        });
                    }
                }, 2500);
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            private final Field myNativeAXResourceField;
            {
                Field field = null;
                if (SystemInfo.isMac) {
                    try {
                        field = ReflectionUtil.findField(AccessibleContext.class, Object.class, (String)"nativeAXResource");
                        field.setAccessible(true);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                this.myNativeAXResourceField = field;
            }

            @Override
            public void eventDispatched(AWTEvent event) {
                if (!SystemInfo.isMac || !Registry.is((String)"ide.mac.fix.accessibleLeak")) {
                    return;
                }
                HierarchyEvent he = (HierarchyEvent)event;
                if ((he.getChangeFlags() & 4L) > 0L && he.getComponent() != null && !he.getComponent().isShowing()) {
                    AccessibleContext ac;
                    ChangeListener[] changeListeners;
                    Component c = he.getComponent();
                    if (c instanceof JTextComponent) {
                        JTextComponent textComponent = (JTextComponent)c;
                        CaretListener[] carets = (CaretListener[])textComponent.getListeners(CaretListener.class);
                        for (EventListener eventListener : carets) {
                            if (!SwingCleanuper.isCAccessibleListener(eventListener)) continue;
                            textComponent.removeCaretListener((CaretListener)eventListener);
                        }
                        Document document = textComponent.getDocument();
                        if (document instanceof AbstractDocument) {
                            DocumentListener[] documentListeners;
                            for (DocumentListener each : documentListeners = ((AbstractDocument)document).getDocumentListeners()) {
                                if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                                document.removeDocumentListener(each);
                            }
                        }
                    } else if (c instanceof JProgressBar) {
                        JProgressBar bar = (JProgressBar)c;
                        changeListeners = bar.getChangeListeners();
                        for (EventListener eventListener : changeListeners) {
                            if (!SwingCleanuper.isCAccessibleListener(eventListener)) continue;
                            bar.removeChangeListener((ChangeListener)eventListener);
                        }
                    } else if (c instanceof JSlider) {
                        JSlider slider = (JSlider)c;
                        changeListeners = slider.getChangeListeners();
                        for (EventListener eventListener : changeListeners) {
                            if (!SwingCleanuper.isCAccessibleListener(eventListener)) continue;
                            slider.removeChangeListener((ChangeListener)eventListener);
                        }
                    }
                    if ((ac = c.getAccessibleContext()) != null && this.myNativeAXResourceField != null) {
                        try {
                            Object resource = this.myNativeAXResourceField.get(ac);
                            if (resource != null && resource.getClass().getName().equals("apple.awt.CAccessible")) {
                                Field accessible = ReflectionUtil.findField(resource.getClass(), Accessible.class, (String)"accessible");
                                accessible.setAccessible(true);
                                accessible.set(resource, null);
                            }
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                }
            }
        }, 32768L);
    }

    private static boolean isCAccessibleListener(EventListener listener) {
        return listener != null && listener.toString().contains("AXTextChangeNotifier");
    }

    private static void resetField(Object object, Class type, @NonNls String name) {
        try {
            ReflectionUtil.resetField((Object)object, (Field)ReflectionUtil.findField(object.getClass(), (Class)type, (String)name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void resetStaticField(@NotNull Class aClass, @NotNull @NonNls String name) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/SwingCleanuper", "resetStaticField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/SwingCleanuper", "resetStaticField"));
        }
        try {
            Field field = aClass.getDeclaredField(name);
            ReflectionUtil.resetField(null, (Field)field);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void disposeComponent() {
    }

    @NotNull
    public final String getComponentName() {
        if ("SwingCleanuper" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/SwingCleanuper", "getComponentName"));
        }
        return "SwingCleanuper";
    }

    public final void initComponent() {
    }

    private static void fixJTextComponentMemoryLeak() throws NoSuchFieldException, IllegalAccessException {
        Field focusedComponentField = JTextComponent.class.getDeclaredField("focusedComponent");
        focusedComponentField.setAccessible(true);
        JTextComponent component = (JTextComponent)focusedComponentField.get(null);
        if (component != null && !component.isDisplayable()) {
            focusedComponentField.set(null, null);
        }
    }
}

