/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class OpenFileXmlRpcHandler {
    private static final Logger LOG = Logger.getInstance(OpenFileXmlRpcHandler.class);

    public boolean open(String path) {
        LOG.debug("open(" + path + ")");
        return OpenFileXmlRpcHandler.doOpen(path, -1, -1);
    }

    public boolean openAndNavigate(String path, int line, int column) {
        LOG.debug("openAndNavigate(" + path + ", " + line + ", " + column + ")");
        return OpenFileXmlRpcHandler.doOpen(path, line, column);
    }

    private static boolean doOpen(final String path, final int line, final int column) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Pair data;
                Pair pair = data = new File(path).isAbsolute() ? OpenFileXmlRpcHandler.findByAbsolutePath(path) : OpenFileXmlRpcHandler.findByRelativePath(path);
                if (data == null) {
                    return;
                }
                FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders((Project)data.second, (VirtualFile)data.first);
                if (providers.length == 0) {
                    return;
                }
                OpenFileDescriptor descriptor = new OpenFileDescriptor((Project)data.second, (VirtualFile)data.first, line, column);
                FileEditorManager.getInstance((Project)((Project)data.second)).openTextEditor(descriptor, true);
            }
        });
        return true;
    }

    @Nullable
    private static Pair<VirtualFile, Project> findByAbsolutePath(String path) {
        Project project;
        VirtualFile vFile;
        File file = new File(FileUtil.toSystemDependentName((String)path));
        if (file.exists() && (vFile = OpenFileXmlRpcHandler.findVirtualFile(file)) != null && (project = ProjectLocator.getInstance().guessProjectForFile(vFile)) != null) {
            return Pair.create((Object)vFile, (Object)project);
        }
        return null;
    }

    @Nullable
    private static Pair<VirtualFile, Project> findByRelativePath(String path) {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        String localPath = FileUtil.toSystemDependentName((String)path);
        for (Project project : projects) {
            File file = new File(project.getBasePath(), localPath);
            if (!file.exists()) continue;
            VirtualFile vFile = OpenFileXmlRpcHandler.findVirtualFile(file);
            return vFile != null ? Pair.create((Object)vFile, (Object)project) : null;
        }
        for (Project project : projects) {
            for (VcsRoot vcsRoot : ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots()) {
                File file;
                VirtualFile root = vcsRoot.getPath();
                if (root == null || !(file = new File(FileUtil.toSystemDependentName((String)root.getPath()), localPath)).exists()) continue;
                VirtualFile vFile = OpenFileXmlRpcHandler.findVirtualFile(file);
                return vFile != null ? Pair.create((Object)vFile, (Object)project) : null;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findVirtualFile(final File file) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            }
        });
    }
}

