/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.AppTopics;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GeneratedSourceFileChangeTrackerImpl
extends GeneratedSourceFileChangeTracker {
    private final FileDocumentManager myDocumentManager;
    private final EditorNotifications myEditorNotifications;
    private final MergingUpdateQueue myCheckingQueue;
    private final Set<VirtualFile> myFilesToCheck = Collections.synchronizedSet(new HashSet());
    private final Set<VirtualFile> myEditedGeneratedFiles = Collections.synchronizedSet(new HashSet());

    public GeneratedSourceFileChangeTrackerImpl(Project project, FileDocumentManager documentManager, EditorNotifications editorNotifications) {
        super(project);
        this.myDocumentManager = documentManager;
        this.myEditorNotifications = editorNotifications;
        this.myCheckingQueue = new MergingUpdateQueue("Checking for changes in generated sources", 500, false, null, (Disposable)project, null, Alarm.ThreadToUse.SHARED_THREAD);
    }

    @Override
    public boolean isEditedGeneratedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl", "isEditedGeneratedFile"));
        }
        return this.myEditedGeneratedFiles.contains(file);
    }

    public void projectOpened() {
        final Update check = new Update("check for changes in generated files"){

            public void run() {
                GeneratedSourceFileChangeTrackerImpl.this.checkFiles();
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                VirtualFile file = GeneratedSourceFileChangeTrackerImpl.this.myDocumentManager.getFile(e.getDocument());
                if (file != null) {
                    GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.add(file);
                    GeneratedSourceFileChangeTrackerImpl.this.myCheckingQueue.queue(check);
                }
            }
        }, (Disposable)this.myProject);
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentReloaded(VirtualFile file, @NotNull Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$3", "fileContentReloaded"));
                }
                GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.remove(file);
                if (GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.remove(file)) {
                    GeneratedSourceFileChangeTrackerImpl.this.myEditorNotifications.updateNotifications(file);
                }
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$4", "fileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$4", "fileClosed"));
                }
                GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.remove(file);
            }
        });
        this.myCheckingQueue.activate();
    }

    public void projectClosed() {
        this.myCheckingQueue.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFiles() {
        VirtualFile[] files;
        Set<VirtualFile> set = this.myFilesToCheck;
        synchronized (set) {
            files = this.myFilesToCheck.toArray(new VirtualFile[this.myFilesToCheck.size()]);
            this.myFilesToCheck.clear();
        }
        final ArrayList newEditedGeneratedFiles = new ArrayList();
        new ReadAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$5", "run"));
                }
                if (GeneratedSourceFileChangeTrackerImpl.this.myProject.isDisposed()) {
                    return;
                }
                for (VirtualFile file : files) {
                    if (!GeneratedSourceFileChangeTrackerImpl.this.isGenerated(file)) continue;
                    newEditedGeneratedFiles.add(file);
                }
            }
        }.execute();
        if (!newEditedGeneratedFiles.isEmpty()) {
            ArrayList<VirtualFile> toNotify = new ArrayList<VirtualFile>();
            Set<VirtualFile> set2 = this.myEditedGeneratedFiles;
            synchronized (set2) {
                for (VirtualFile file : newEditedGeneratedFiles) {
                    if (!this.myEditedGeneratedFiles.add(file)) continue;
                    toNotify.add(file);
                }
            }
            for (VirtualFile file : toNotify) {
                this.myEditorNotifications.updateNotifications(file);
            }
        }
    }

    private boolean isGenerated(VirtualFile file) {
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions()) {
            if (!filter.isGeneratedSource(file, this.myProject)) continue;
            return true;
        }
        return false;
    }
}

