/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.Nullable;

public class GeneratedFileEditingNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"generated.source.file.editing.notification.panel");
    private final GeneratedSourceFileChangeTracker myChangeTracker;

    public GeneratedFileEditingNotificationProvider(GeneratedSourceFileChangeTracker changeTracker) {
        this.myChangeTracker = changeTracker;
    }

    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor) {
        if (!this.myChangeTracker.isEditedGeneratedFile(file)) {
            return null;
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText("Generated source files should not be edited. The changes will be lost when sources are regenerated.");
        return panel;
    }
}

