/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameStateManagerImpl
extends FrameStateManager
implements ApplicationComponent {
    private final List<FrameStateListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myShouldSynchronize;
    private final Alarm mySyncAlarm;
    private final BusyObject.Impl myActive;
    private final ApplicationImpl myApp;

    public FrameStateManagerImpl(final ApplicationImpl app) {
        this.myApp = app;
        this.myActive = new BusyObject.Impl(){

            public boolean isReady() {
                return FrameStateManagerImpl.this.myApp.isActive();
            }
        };
        this.myShouldSynchronize = false;
        this.mySyncAlarm = new Alarm();
        app.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationActivated(IdeFrame ideFrame) {
                FrameStateManagerImpl.this.myActive.onReady();
                FrameStateManagerImpl.this.mySyncAlarm.cancelAllRequests();
                if (FrameStateManagerImpl.this.myShouldSynchronize) {
                    FrameStateManagerImpl.this.myShouldSynchronize = false;
                    FrameStateManagerImpl.this.fireActivationEvent();
                }
            }

            public void applicationDeactivated(IdeFrame ideFrame) {
                FrameStateManagerImpl.this.mySyncAlarm.cancelAllRequests();
                FrameStateManagerImpl.this.mySyncAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (!app.isActive() && !app.isDisposed()) {
                            FrameStateManagerImpl.this.myShouldSynchronize = true;
                            FrameStateManagerImpl.this.fireDeactivationEvent();
                        }
                    }
                }, 200);
            }
        });
    }

    public ActionCallback getApplicationActive() {
        return this.myActive.getReady((Object)this);
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("FrameStateManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/FrameStateManagerImpl", "getComponentName"));
        }
        return "FrameStateManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void fireDeactivationEvent() {
        for (FrameStateListener listener : this.myListeners) {
            listener.onFrameDeactivated();
        }
    }

    private void fireActivationEvent() {
        for (FrameStateListener listener : this.myListeners) {
            listener.onFrameActivated();
        }
    }

    public void addListener(@NotNull FrameStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/FrameStateManagerImpl", "addListener"));
        }
        this.addListener(listener, null);
    }

    public void addListener(final @NotNull FrameStateListener listener, @Nullable Disposable disposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/FrameStateManagerImpl", "addListener"));
        }
        this.myListeners.add(listener);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    FrameStateManagerImpl.this.removeListener(listener);
                }
            });
        }
    }

    public void removeListener(@NotNull FrameStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/FrameStateManagerImpl", "removeListener"));
        }
        this.myListeners.remove(listener);
    }
}

