/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChangedNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Logger LOG = Logger.getInstance(FileChangedNotificationProvider.class);
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.changed.notification.panel");
    private final Project myProject;

    public FileChangedNotificationProvider(@NotNull Project project, @NotNull FrameStateManager frameStateManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/FileChangedNotificationProvider", "<init>"));
        }
        if (frameStateManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/FileChangedNotificationProvider", "<init>"));
        }
        this.myProject = project;
        frameStateManager.addListener((FrameStateListener)new FrameStateListener.Adapter(){

            public void onFrameActivated() {
                if (!FileChangedNotificationProvider.this.myProject.isDisposed() && !GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)FileChangedNotificationProvider.this.myProject);
                    for (VirtualFile file : FileEditorManager.getInstance((Project)FileChangedNotificationProvider.this.myProject).getSelectedFiles()) {
                        notifications.updateNotifications(file);
                    }
                }
            }
        }, (Disposable)project);
    }

    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        FileAttributes attributes;
        VirtualFileSystem fs;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/FileChangedNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/FileChangedNotificationProvider", "createNotificationPanel"));
        }
        if (!(this.myProject.isDisposed() || GeneralSettings.getInstance().isSyncOnFrameActivation() || !((fs = file.getFileSystem()) instanceof LocalFileSystem) || (attributes = ((LocalFileSystem)fs).getAttributes(file)) != null && file.getTimeStamp() == attributes.lastModified && file.getLength() == attributes.length)) {
            LogUtil.debug((Logger)LOG, (String)"%s: (%s,%s) -> %s", (Object[])new Object[]{file, file.getTimeStamp(), file.getLength(), attributes});
            return this.createPanel(file);
        }
        return null;
    }

    private EditorNotificationPanel createPanel(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/FileChangedNotificationProvider", "createPanel"));
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(IdeBundle.message((String)"file.changed.externally.message", (Object[])new Object[0]));
        panel.createActionLabel(IdeBundle.message((String)"file.changed.externally.reload", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                if (!FileChangedNotificationProvider.this.myProject.isDisposed()) {
                    RefreshQueue.getInstance().refresh(false, false, null, new VirtualFile[]{file});
                    EditorNotifications.getInstance((Project)FileChangedNotificationProvider.this.myProject).updateNotifications(file);
                }
            }
        });
        return panel;
    }
}

