/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public interface AppLifecycleListener {
    public static final Topic<AppLifecycleListener> TOPIC = Topic.create((String)"Application lifecycle notifications", AppLifecycleListener.class);

    public void appFrameCreated(String[] var1, @NotNull Ref<Boolean> var2);

    public void appStarting(Project var1);

    public void projectFrameClosed();

    public void projectOpenFailed();

    public void welcomeScreenDisplayed();

    public void appClosing();

    public static abstract class Adapter
    implements AppLifecycleListener {
        @Override
        public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
            if (willOpenProject == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/AppLifecycleListener$Adapter", "appFrameCreated"));
            }
        }

        @Override
        public void appStarting(Project projectFromCommandLine) {
        }

        @Override
        public void projectFrameClosed() {
        }

        @Override
        public void projectOpenFailed() {
        }

        @Override
        public void welcomeScreenDisplayed() {
        }

        @Override
        public void appClosing() {
        }
    }
}

