/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Content;
import com.intellij.history.core.StreamUtil;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.util.Producer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSet {
    private final long myId;
    @Nullable
    private String myName;
    private final long myTimestamp;
    private final List<Change> myChanges;
    private volatile boolean isLocked = false;

    public ChangeSet(long id, long timestamp) {
        this.myId = id;
        this.myTimestamp = timestamp;
        this.myChanges = ContainerUtil.createLockFreeCopyOnWriteList();
    }

    public ChangeSet(DataInput in) throws IOException {
        this.myId = in.readLong();
        this.myName = StreamUtil.readStringOrNull(in);
        this.myTimestamp = in.readLong();
        int count = in.readInt();
        ArrayList<Change> changes = new ArrayList<Change>(count);
        while (count-- > 0) {
            changes.add(StreamUtil.readChange(in));
        }
        this.myChanges = Collections.unmodifiableList(changes);
        this.isLocked = true;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.myId);
        StreamUtil.writeStringOrNull(out, this.myName);
        out.writeLong(this.myTimestamp);
        out.writeInt(this.myChanges.size());
        for (Change c : this.myChanges) {
            StreamUtil.writeChange(out, c);
        }
    }

    public void setName(@Nullable String name) {
        this.myName = name;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public void lock() {
        this.isLocked = true;
    }

    @Nullable
    public String getLabel() {
        return this.accessChanges(new Producer<String>(){

            public String produce() {
                for (Change each : ChangeSet.this.myChanges) {
                    if (!(each instanceof PutLabelChange)) continue;
                    return ((PutLabelChange)each).getName();
                }
                return null;
            }
        });
    }

    public int getLabelColor() {
        return this.accessChanges(new Producer<Integer>(){

            public Integer produce() {
                for (Change each : ChangeSet.this.myChanges) {
                    if (!(each instanceof PutSystemLabelChange)) continue;
                    return ((PutSystemLabelChange)each).getColor();
                }
                return -1;
            }
        });
    }

    public void addChange(final Change c) {
        LocalHistoryLog.LOG.assertTrue(!this.isLocked, (Object)"Changset is already locked");
        this.accessChanges(new Runnable(){

            @Override
            public void run() {
                ChangeSet.this.myChanges.add(c);
            }
        });
    }

    public List<Change> getChanges() {
        return this.accessChanges(new Producer<List<Change>>(){

            public List<Change> produce() {
                if (ChangeSet.this.isLocked) {
                    return ChangeSet.this.myChanges;
                }
                return Collections.unmodifiableList(new ArrayList(ChangeSet.this.myChanges));
            }
        });
    }

    public boolean isEmpty() {
        return this.accessChanges(new Producer<Boolean>(){

            public Boolean produce() {
                return ChangeSet.this.myChanges.isEmpty();
            }
        });
    }

    public boolean affectsPath(final String paths) {
        return this.accessChanges(new Producer<Boolean>(){

            public Boolean produce() {
                for (Change c : ChangeSet.this.myChanges) {
                    if (!c.affectsPath(paths)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public boolean isCreationalFor(final String path) {
        return this.accessChanges(new Producer<Boolean>(){

            public Boolean produce() {
                for (Change c : ChangeSet.this.myChanges) {
                    if (!c.isCreationalFor(path)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public List<Content> getContentsToPurge() {
        return this.accessChanges(new Producer<List<Content>>(){

            public List<Content> produce() {
                ArrayList<Content> result = new ArrayList<Content>();
                for (Change c : ChangeSet.this.myChanges) {
                    result.addAll(c.getContentsToPurge());
                }
                return result;
            }
        });
    }

    public boolean isContentChangeOnly() {
        return this.accessChanges(new Producer<Boolean>(){

            public Boolean produce() {
                return ChangeSet.this.myChanges.size() == 1 && ChangeSet.this.getFirstChange() instanceof ContentChange;
            }
        });
    }

    public boolean isLabelOnly() {
        return this.accessChanges(new Producer<Boolean>(){

            public Boolean produce() {
                return ChangeSet.this.myChanges.size() == 1 && ChangeSet.this.getFirstChange() instanceof PutLabelChange;
            }
        });
    }

    public Change getFirstChange() {
        return this.accessChanges(new Producer<Change>(){

            public Change produce() {
                return (Change)ChangeSet.this.myChanges.get(0);
            }
        });
    }

    public Change getLastChange() {
        return this.accessChanges(new Producer<Change>(){

            public Change produce() {
                return (Change)ChangeSet.this.myChanges.get(ChangeSet.this.myChanges.size() - 1);
            }
        });
    }

    public List<String> getAffectedPaths() {
        return this.accessChanges(new Producer<List<String>>(){

            public List<String> produce() {
                SmartList result = new SmartList();
                for (Change each : ChangeSet.this.myChanges) {
                    if (!(each instanceof StructuralChange)) continue;
                    result.add(((StructuralChange)each).getPath());
                }
                return result;
            }
        });
    }

    public String toString() {
        return this.accessChanges(new Producer<String>(){

            public String produce() {
                return ChangeSet.this.myChanges.toString();
            }
        });
    }

    public long getId() {
        return this.myId;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeSet change = (ChangeSet)o;
        return this.myId == change.myId;
    }

    public final int hashCode() {
        return (int)(this.myId ^ this.myId >>> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        if (this.isLocked) {
            this.doAccept(v);
            return;
        }
        List<Change> list = this.myChanges;
        synchronized (list) {
            this.doAccept(v);
        }
    }

    private void doAccept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        v.begin(this);
        for (Change c : ContainerUtil.iterateBackward(this.myChanges)) {
            c.accept(v);
        }
        v.end(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T accessChanges(@NotNull Producer<T> func) {
        if (func == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/history/core/changes/ChangeSet", "accessChanges"));
        }
        if (this.isLocked) {
            return (T)func.produce();
        }
        List<Change> list = this.myChanges;
        synchronized (list) {
            return (T)func.produce();
        }
    }

    private void accessChanges(final @NotNull Runnable func) {
        if (func == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/history/core/changes/ChangeSet", "accessChanges"));
        }
        this.accessChanges(new Producer<Object>(){

            public Object produce() {
                func.run();
                return null;
            }
        });
    }
}

