/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.LibraryBasedFrameworkSupportProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.libraries.LibraryType;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class LibraryBasedFrameworkType
extends FrameworkTypeEx {
    private static final Logger LOG = Logger.getInstance(LibraryBasedFrameworkType.class);
    private final Class<? extends DownloadableLibraryType> myLibraryTypeClass;

    protected LibraryBasedFrameworkType(@NotNull String id, Class<? extends DownloadableLibraryType> libraryTypeClass) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/library/LibraryBasedFrameworkType", "<init>"));
        }
        super(id);
        this.myLibraryTypeClass = libraryTypeClass;
    }

    protected Class<? extends DownloadableLibraryType> getLibraryTypeClass() {
        return this.myLibraryTypeClass;
    }

    @Override
    @NotNull
    public FrameworkSupportInModuleProvider createProvider() {
        LibraryBasedFrameworkSupportProvider libraryBasedFrameworkSupportProvider = new LibraryBasedFrameworkSupportProvider(this, this.myLibraryTypeClass);
        if (libraryBasedFrameworkSupportProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/LibraryBasedFrameworkType", "createProvider"));
        }
        return libraryBasedFrameworkSupportProvider;
    }

    @NotNull
    public Icon getIcon() {
        DownloadableLibraryType libraryType = this.getLibraryType();
        Icon icon = libraryType.getIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/LibraryBasedFrameworkType", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public DownloadableLibraryType getLibraryType() {
        DownloadableLibraryType libraryType = (DownloadableLibraryType)LibraryType.EP_NAME.findExtension(this.myLibraryTypeClass);
        LOG.assertTrue(libraryType != null, this.myLibraryTypeClass);
        DownloadableLibraryType downloadableLibraryType = libraryType;
        if (downloadableLibraryType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/LibraryBasedFrameworkType", "getLibraryType"));
        }
        return downloadableLibraryType;
    }
}

