/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LibraryBasedFrameworkSupportProvider
extends FrameworkSupportInModuleProvider {
    private final FrameworkTypeEx myFrameworkType;
    private final Class<? extends DownloadableLibraryType> myLibraryTypeClass;

    public LibraryBasedFrameworkSupportProvider(FrameworkTypeEx frameworkType, Class<? extends DownloadableLibraryType> libraryTypeClass) {
        this.myFrameworkType = frameworkType;
        this.myLibraryTypeClass = libraryTypeClass;
    }

    @Override
    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        FrameworkTypeEx frameworkTypeEx = this.myFrameworkType;
        if (frameworkTypeEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/LibraryBasedFrameworkSupportProvider", "getFrameworkType"));
        }
        return frameworkTypeEx;
    }

    @Override
    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/library/LibraryBasedFrameworkSupportProvider", "createConfigurable"));
        }
        LibrarySupportConfigurable librarySupportConfigurable = new LibrarySupportConfigurable();
        if (librarySupportConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/LibraryBasedFrameworkSupportProvider", "createConfigurable"));
        }
        return librarySupportConfigurable;
    }

    @Override
    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/library/LibraryBasedFrameworkSupportProvider", "isEnabledForModuleType"));
        }
        return moduleType instanceof JavaModuleType;
    }

    private class LibrarySupportConfigurable
    extends FrameworkSupportInModuleConfigurable {
        private LibrarySupportConfigurable() {
        }

        @Override
        public JComponent createComponent() {
            return null;
        }

        @Override
        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/library/LibraryBasedFrameworkSupportProvider$LibrarySupportConfigurable", "addSupport"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/library/LibraryBasedFrameworkSupportProvider$LibrarySupportConfigurable", "addSupport"));
            }
            if (modifiableModelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/framework/library/LibraryBasedFrameworkSupportProvider$LibrarySupportConfigurable", "addSupport"));
            }
        }

        @Override
        @NotNull
        public CustomLibraryDescription createLibraryDescription() {
            CustomLibraryDescription customLibraryDescription = DownloadableLibraryService.getInstance().createDescriptionForType(LibraryBasedFrameworkSupportProvider.this.myLibraryTypeClass);
            if (customLibraryDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/LibraryBasedFrameworkSupportProvider$LibrarySupportConfigurable", "createLibraryDescription"));
            }
            return customLibraryDescription;
        }

        @Override
        public boolean isOnlyLibraryAdded() {
            return true;
        }
    }
}

