/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude;

import com.intellij.framework.detection.impl.exclude.ExcludeListItem;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;

class InvalidExcludeListItem
extends ExcludeListItem {
    private final String myFileUrl;
    private final String myFrameworkTypeId;

    InvalidExcludeListItem(String frameworkTypeId, String fileUrl) {
        this.myFrameworkTypeId = frameworkTypeId;
        this.myFileUrl = fileUrl;
    }

    @Override
    public String getFrameworkTypeId() {
        return this.myFrameworkTypeId;
    }

    @Override
    public String getFileUrl() {
        return this.myFileUrl;
    }

    @Override
    public void renderItem(ColoredListCellRenderer renderer) {
        if (this.myFrameworkTypeId != null) {
            renderer.append(this.myFrameworkTypeId, SimpleTextAttributes.ERROR_ATTRIBUTES);
            if (this.myFileUrl != null) {
                renderer.append(" in " + this.myFileUrl, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        } else {
            renderer.append(this.myFileUrl, SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    @Override
    public String getPresentableFrameworkName() {
        return this.myFrameworkTypeId;
    }
}

