/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.facet.FacetType;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkDetectionUtil {
    private FrameworkDetectionUtil() {
    }

    @Nullable
    public static FrameworkType findFrameworkTypeForFacetDetector(@NotNull FacetType<?, ?> facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/impl/FrameworkDetectionUtil", "findFrameworkTypeForFacetDetector"));
        }
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            if (!(detector instanceof FacetBasedFrameworkDetector) || !((FacetBasedFrameworkDetector)detector).getFacetType().equals(facetType)) continue;
            return detector.getFrameworkType();
        }
        return null;
    }

    public static List<? extends DetectedFrameworkDescription> removeDisabled(List<DetectedFrameworkDescription> descriptions) {
        return FrameworkDetectionUtil.removeDisabled(descriptions, Collections.emptyList());
    }

    public static List<DetectedFrameworkDescription> getDisabledDescriptions(@NotNull List<? extends DetectedFrameworkDescription> currentDescriptions, @NotNull List<? extends DetectedFrameworkDescription> otherDescriptions) {
        if (currentDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/impl/FrameworkDetectionUtil", "getDisabledDescriptions"));
        }
        if (otherDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/detection/impl/FrameworkDetectionUtil", "getDisabledDescriptions"));
        }
        return FrameworkDetectionUtil.doGetDisabledDescriptions(currentDescriptions, ContainerUtil.concat(currentDescriptions, otherDescriptions));
    }

    private static List<DetectedFrameworkDescription> doGetDisabledDescriptions(@NotNull List<? extends DetectedFrameworkDescription> currentDescriptions, @NotNull List<? extends DetectedFrameworkDescription> allDescriptions) {
        if (currentDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/impl/FrameworkDetectionUtil", "doGetDisabledDescriptions"));
        }
        if (allDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/detection/impl/FrameworkDetectionUtil", "doGetDisabledDescriptions"));
        }
        ArrayList<DetectedFrameworkDescription> disabled = new ArrayList<DetectedFrameworkDescription>();
        for (DetectedFrameworkDescription detectedFrameworkDescription : currentDescriptions) {
            if (detectedFrameworkDescription.canSetupFramework(allDescriptions)) continue;
            disabled.add(detectedFrameworkDescription);
        }
        if (!disabled.isEmpty()) {
            ArrayList<? extends DetectedFrameworkDescription> remaining = new ArrayList<DetectedFrameworkDescription>(currentDescriptions);
            remaining.removeAll(disabled);
            disabled.addAll(FrameworkDetectionUtil.doGetDisabledDescriptions(remaining, allDescriptions));
        }
        return disabled;
    }

    public static List<? extends DetectedFrameworkDescription> removeDisabled(@NotNull List<? extends DetectedFrameworkDescription> currentDescriptions, @NotNull List<? extends DetectedFrameworkDescription> otherDescriptions) {
        if (currentDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/impl/FrameworkDetectionUtil", "removeDisabled"));
        }
        if (otherDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/detection/impl/FrameworkDetectionUtil", "removeDisabled"));
        }
        List<DetectedFrameworkDescription> disabled = FrameworkDetectionUtil.getDisabledDescriptions(currentDescriptions, otherDescriptions);
        if (disabled.isEmpty()) {
            return currentDescriptions;
        }
        ArrayList<? extends DetectedFrameworkDescription> descriptions = new ArrayList<DetectedFrameworkDescription>(currentDescriptions);
        descriptions.removeAll(disabled);
        return descriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupFrameworks(List<? extends DetectedFrameworkDescription> descriptions, ModifiableModelsProvider modelsProvider, ModulesProvider modulesProvider) {
        AccessToken token = WriteAction.start();
        try {
            ArrayList<DetectedFrameworkDescription> sortedDescriptions = new ArrayList<DetectedFrameworkDescription>();
            for (DetectedFrameworkDescription detectedFrameworkDescription : descriptions) {
                if (detectedFrameworkDescription.getDetector().getUnderlyingFrameworkType() != null) continue;
                sortedDescriptions.add(detectedFrameworkDescription);
            }
            for (DetectedFrameworkDescription detectedFrameworkDescription : descriptions) {
                if (detectedFrameworkDescription.getDetector().getUnderlyingFrameworkType() == null) continue;
                sortedDescriptions.add(detectedFrameworkDescription);
            }
            for (DetectedFrameworkDescription detectedFrameworkDescription : sortedDescriptions) {
                detectedFrameworkDescription.setupFramework(modelsProvider, modulesProvider);
            }
        }
        finally {
            token.finish();
        }
    }
}

