/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistryImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DetectedFrameworksData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.DetectedFrameworksData");
    private PersistentHashMap<Integer, TIntHashSet> myExistentFrameworkFiles;
    private final TIntObjectHashMap<TIntHashSet> myNewFiles;
    private final MultiMap<Integer, DetectedFrameworkDescription> myDetectedFrameworks = new MultiMap();

    public DetectedFrameworksData(Project project) {
        File file = new File(FrameworkDetectorRegistryImpl.getDetectionDirPath() + File.separator + project.getName() + "." + project.getLocationHash() + File.separator + "files");
        this.myNewFiles = new TIntObjectHashMap();
        try {
            this.myExistentFrameworkFiles = new PersistentHashMap(file, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new TIntHashSetExternalizer());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            PersistentHashMap.deleteFilesStartingWith((File)file);
            try {
                this.myExistentFrameworkFiles = new PersistentHashMap(file, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new TIntHashSetExternalizer());
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
        }
    }

    public void saveDetected() {
        try {
            this.myExistentFrameworkFiles.close();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public Collection<VirtualFile> retainNewFiles(@NotNull Integer detectorId, @NotNull Collection<VirtualFile> files) {
        if (detectorId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/impl/DetectedFrameworksData", "retainNewFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/detection/impl/DetectedFrameworksData", "retainNewFiles"));
        }
        TIntHashSet oldSet = (TIntHashSet)this.myNewFiles.get(detectorId.intValue());
        if (oldSet == null) {
            oldSet = new TIntHashSet();
            this.myNewFiles.put(detectorId.intValue(), (Object)oldSet);
        }
        TIntHashSet existentFilesSet = null;
        try {
            existentFilesSet = (TIntHashSet)this.myExistentFrameworkFiles.get((Object)detectorId);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
        TIntHashSet newSet = new TIntHashSet();
        for (VirtualFile file : files) {
            int fileId = FileBasedIndex.getFileId((VirtualFile)file);
            if (existentFilesSet != null && existentFilesSet.contains(fileId)) continue;
            newFiles.add(file);
            newSet.add(fileId);
        }
        if (newSet.equals((Object)oldSet)) {
            return Collections.emptyList();
        }
        this.myNewFiles.put(detectorId.intValue(), (Object)newSet);
        return newFiles;
    }

    public Set<Integer> getDetectorsForDetectedFrameworks() {
        return this.myDetectedFrameworks.keySet();
    }

    public Collection<? extends DetectedFrameworkDescription> updateFrameworksList(Integer detectorId, Collection<? extends DetectedFrameworkDescription> frameworks) {
        Collection oldFrameworks = this.myDetectedFrameworks.remove((Object)detectorId);
        this.myDetectedFrameworks.putValues((Object)detectorId, frameworks);
        if (oldFrameworks != null) {
            frameworks.removeAll(oldFrameworks);
        }
        return frameworks;
    }

    public void putExistentFrameworkFiles(Integer id, Collection<? extends VirtualFile> files) {
        TIntHashSet set = null;
        try {
            set = (TIntHashSet)this.myExistentFrameworkFiles.get((Object)id);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        if (set == null) {
            set = new TIntHashSet();
            try {
                this.myExistentFrameworkFiles.put((Object)id, (Object)set);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        for (VirtualFile virtualFile : files) {
            set.add(FileBasedIndex.getFileId((VirtualFile)virtualFile));
        }
    }

    private static class TIntHashSetExternalizer
    implements DataExternalizer<TIntHashSet> {
        private TIntHashSetExternalizer() {
        }

        public void save(@NotNull DataOutput out, TIntHashSet value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/impl/DetectedFrameworksData$TIntHashSetExternalizer", "save"));
            }
            out.writeInt(value.size());
            TIntIterator iterator = value.iterator();
            while (iterator.hasNext()) {
                out.writeInt(iterator.next());
            }
        }

        public TIntHashSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/impl/DetectedFrameworksData$TIntHashSetExternalizer", "read"));
            }
            int size = in.readInt();
            TIntHashSet set = new TIntHashSet(size);
            while (size-- > 0) {
                set.add(in.readInt());
            }
            return set;
        }
    }
}

