/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AlignmentStrategy {
    private static final AlignmentStrategy NULL_STRATEGY = AlignmentStrategy.wrap(null, new IElementType[0]);

    public static AlignmentStrategy getNullStrategy() {
        return NULL_STRATEGY;
    }

    public static AlignmentStrategy wrap(@Nullable Alignment alignment, IElementType ... filterTypes) {
        return new SharedAlignmentStrategy(alignment, true, filterTypes);
    }

    public static AlignmentStrategy wrap(Alignment alignment, boolean ignoreFilterTypes, IElementType ... filterTypes) {
        return new SharedAlignmentStrategy(alignment, ignoreFilterTypes, filterTypes);
    }

    public static AlignmentPerTypeStrategy createAlignmentPerTypeStrategy(@NotNull Collection<IElementType> targetTypes, boolean allowBackwardShift) {
        if (targetTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/alignment/AlignmentStrategy", "createAlignmentPerTypeStrategy"));
        }
        return new AlignmentPerTypeStrategy(targetTypes, null, allowBackwardShift, Alignment.Anchor.LEFT);
    }

    public static AlignmentPerTypeStrategy createAlignmentPerTypeStrategy(@NotNull Collection<IElementType> targetTypes, @Nullable IElementType parentType, boolean allowBackwardShift) {
        if (targetTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/alignment/AlignmentStrategy", "createAlignmentPerTypeStrategy"));
        }
        return AlignmentStrategy.createAlignmentPerTypeStrategy(targetTypes, parentType, allowBackwardShift, Alignment.Anchor.LEFT);
    }

    public static AlignmentPerTypeStrategy createAlignmentPerTypeStrategy(@NotNull Collection<IElementType> targetTypes, @Nullable IElementType parentType, boolean allowBackwardShift, @NotNull Alignment.Anchor anchor) {
        if (targetTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/alignment/AlignmentStrategy", "createAlignmentPerTypeStrategy"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/formatting/alignment/AlignmentStrategy", "createAlignmentPerTypeStrategy"));
        }
        return new AlignmentPerTypeStrategy(targetTypes, parentType, allowBackwardShift, anchor);
    }

    @Nullable
    public Alignment getAlignment(@Nullable IElementType childType) {
        return this.getAlignment(null, childType);
    }

    @Nullable
    public abstract Alignment getAlignment(@Nullable IElementType var1, @Nullable IElementType var2);

    public static class AlignmentPerTypeStrategy
    extends AlignmentStrategy {
        private final Map<IElementType, Alignment> myAlignments = new HashMap<IElementType, Alignment>();
        private final IElementType myParentType;
        private final boolean myAllowBackwardShift;

        AlignmentPerTypeStrategy(Collection<IElementType> targetElementTypes, IElementType parentType, boolean allowBackwardShift, Alignment.Anchor anchor) {
            this.myParentType = parentType;
            this.myAllowBackwardShift = allowBackwardShift;
            for (IElementType elementType : targetElementTypes) {
                this.myAlignments.put(elementType, Alignment.createAlignment((boolean)this.myAllowBackwardShift, (Alignment.Anchor)anchor));
            }
        }

        @Override
        public Alignment getAlignment(@Nullable IElementType parentType, @Nullable IElementType childType) {
            if (this.myParentType != null && parentType != null && this.myParentType != parentType) {
                return null;
            }
            return this.myAlignments.get(childType);
        }

        public void renewAlignment(IElementType elementType) {
            this.myAlignments.put(elementType, Alignment.createAlignment((boolean)this.myAllowBackwardShift));
        }
    }

    private static class SharedAlignmentStrategy
    extends AlignmentStrategy {
        private final Set<IElementType> myFilterElementTypes = new HashSet<IElementType>();
        private final Alignment myAlignment;
        private final boolean myIgnoreFilterTypes;

        private SharedAlignmentStrategy(Alignment alignment, boolean ignoreFilterTypes, IElementType ... disabledElementTypes) {
            this.myAlignment = alignment;
            this.myIgnoreFilterTypes = ignoreFilterTypes;
            this.myFilterElementTypes.addAll(Arrays.asList(disabledElementTypes));
        }

        @Override
        @Nullable
        public Alignment getAlignment(@Nullable IElementType parentType, @Nullable IElementType childType) {
            return this.myFilterElementTypes.contains(childType) ^ this.myIgnoreFilterTypes ? this.myAlignment : null;
        }
    }
}

