/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;

public class IndentInfo {
    private final int mySpaces;
    private final int myIndentSpaces;
    private final int myLineFeeds;
    private final boolean myForceSkipTabulationsUsage;

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces) {
        this(lineFeeds, indentSpaces, spaces, false);
    }

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces, boolean forceSkipTabulationsUsage) {
        this.mySpaces = spaces;
        this.myIndentSpaces = indentSpaces;
        this.myLineFeeds = lineFeeds;
        this.myForceSkipTabulationsUsage = forceSkipTabulationsUsage;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    public int getIndentSpaces() {
        return this.myIndentSpaces;
    }

    public String generateNewWhiteSpace(CommonCodeStyleSettings.IndentOptions options) {
        StringBuffer buffer = new StringBuffer();
        StringUtil.repeatSymbol((Appendable)buffer, (char)'\n', (int)this.myLineFeeds);
        if (options.USE_TAB_CHARACTER && (!this.myForceSkipTabulationsUsage || this.myLineFeeds > 0)) {
            if (options.SMART_TABS) {
                int tabCount = this.myIndentSpaces / options.TAB_SIZE;
                int leftSpaces = this.myIndentSpaces - tabCount * options.TAB_SIZE;
                if (tabCount > 0) {
                    StringUtil.repeatSymbol((Appendable)buffer, (char)'\t', (int)tabCount);
                }
                if (leftSpaces + this.mySpaces > 0) {
                    StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(leftSpaces + this.mySpaces));
                }
            } else {
                int size = this.getTotalSpaces();
                while (size > 0) {
                    if (size >= options.TAB_SIZE) {
                        buffer.append('\t');
                        size -= options.TAB_SIZE;
                        continue;
                    }
                    buffer.append(' ');
                    --size;
                }
            }
        } else {
            int spaces = this.getTotalSpaces();
            if (spaces > 0) {
                StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)spaces);
            }
        }
        return buffer.toString();
    }

    public int getTotalSpaces() {
        return this.myIndentSpaces + this.mySpaces;
    }
}

