/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesOptions
extends UserDataHolderBase
implements Cloneable {
    public SearchScope searchScope;
    public boolean isSearchForTextOccurrences;
    public boolean isUsages;
    public SearchRequestCollector fastTrack;

    public FindUsagesOptions(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/FindUsagesOptions", "<init>"));
        }
        this(project, null);
    }

    public FindUsagesOptions(@NotNull Project project, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/FindUsagesOptions", "<init>"));
        }
        this.isSearchForTextOccurrences = true;
        this.isUsages = false;
        this.fastTrack = null;
        String defaultScopeName = FindSettings.getInstance().getDefaultScopeName();
        List<SearchScope> predefined = ScopeChooserCombo.getPredefinedScopes(project, dataContext, true, false, false, false);
        for (SearchScope scope : predefined) {
            if (!scope.getDisplayName().equals(defaultScopeName)) continue;
            this.searchScope = scope;
            break;
        }
        if (this.searchScope == null) {
            this.searchScope = ProjectScope.getProjectScope((Project)project);
        }
    }

    public FindUsagesOptions(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/FindUsagesOptions", "<init>"));
        }
        this.isSearchForTextOccurrences = true;
        this.isUsages = false;
        this.fastTrack = null;
        this.searchScope = searchScope;
    }

    public FindUsagesOptions clone() {
        return (FindUsagesOptions)super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindUsagesOptions that = (FindUsagesOptions)o;
        if (this.isSearchForTextOccurrences != that.isSearchForTextOccurrences) {
            return false;
        }
        if (this.isUsages != that.isUsages) {
            return false;
        }
        return !(this.searchScope != null ? !this.searchScope.equals(that.searchScope) : that.searchScope != null);
    }

    public int hashCode() {
        int result = this.searchScope == null ? 0 : this.searchScope.hashCode();
        result = 31 * result + (this.isSearchForTextOccurrences ? 1 : 0);
        result = 31 * result + (this.isUsages ? 1 : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "searchScope=" + this.searchScope + ", isSearchForTextOccurrences=" + this.isSearchForTextOccurrences + ", isUsages=" + this.isUsages + '}';
    }

    @NotNull
    public String generateUsagesString() {
        String string = FindBundle.message("find.usages.panel.title.usages", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesOptions", "generateUsagesString"));
        }
        return string;
    }
}

