/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class FindMethodUsagesDialog
extends JavaFindUsagesDialog<JavaMethodFindUsagesOptions> {
    private StateRestoringCheckBox myCbUsages;
    private StateRestoringCheckBox myCbImplementingMethods;
    private StateRestoringCheckBox myCbOverridingMethods;
    private boolean myHasFindWhatPanel;

    public FindMethodUsagesDialog(PsiElement element, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(element, project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedControl() {
        return this.myHasFindWhatPanel ? this.myCbUsages : null;
    }

    @Override
    public void calcFindUsagesOptions(JavaMethodFindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        boolean bl = options.isUsages = FindMethodUsagesDialog.isSelected(this.myCbUsages) || !this.myHasFindWhatPanel;
        if (FindMethodUsagesDialog.isToChange(this.myCbOverridingMethods)) {
            options.isOverridingMethods = FindMethodUsagesDialog.isSelected(this.myCbOverridingMethods);
        }
        if (FindMethodUsagesDialog.isToChange(this.myCbImplementingMethods)) {
            options.isImplementingMethods = FindMethodUsagesDialog.isSelected(this.myCbImplementingMethods);
        }
        options.isCheckDeepInheritance = true;
    }

    @Override
    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.what.group", new Object[0]), (boolean)true));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        this.myCbUsages = this.addCheckboxToPanel(FindBundle.message("find.what.usages.checkbox", new Object[0]), ((JavaMethodFindUsagesOptions)this.getFindUsagesOptions()).isUsages, findWhatPanel, true);
        PsiMethod method = (PsiMethod)this.getPsiElement();
        PsiClass aClass = method.getContainingClass();
        if (!(method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private") || aClass == null || aClass instanceof PsiAnonymousClass || aClass.hasModifierProperty("final"))) {
            if (method.hasModifierProperty("abstract")) {
                this.myCbImplementingMethods = this.addCheckboxToPanel(FindBundle.message("find.what.implementing.methods.checkbox", new Object[0]), ((JavaMethodFindUsagesOptions)this.getFindUsagesOptions()).isImplementingMethods, findWhatPanel, true);
            } else {
                this.myCbOverridingMethods = this.addCheckboxToPanel(FindBundle.message("find.what.overriding.methods.checkbox", new Object[0]), ((JavaMethodFindUsagesOptions)this.getFindUsagesOptions()).isOverridingMethods, findWhatPanel, true);
            }
        } else {
            this.myHasFindWhatPanel = false;
            return null;
        }
        this.myHasFindWhatPanel = true;
        return findWhatPanel;
    }

    @Override
    protected void update() {
        if (!this.myHasFindWhatPanel) {
            this.setOKActionEnabled(true);
        } else {
            boolean hasSelected = FindMethodUsagesDialog.isSelected(this.myCbUsages) || FindMethodUsagesDialog.isSelected(this.myCbImplementingMethods) || FindMethodUsagesDialog.isSelected(this.myCbOverridingMethods);
            this.setOKActionEnabled(hasSelected);
        }
    }
}

