/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.facetType;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.ui.DefaultFacetSettingsEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DefaultFacetSettingsConfigurable<C extends FacetConfiguration>
implements Configurable {
    private final FacetType<?, C> myFacetType;
    private final Project myProject;
    private final DefaultFacetSettingsEditor myDelegate;
    private final C myConfiguration;

    public DefaultFacetSettingsConfigurable(@NotNull FacetType<?, C> facetType, @NotNull Project project, @NotNull DefaultFacetSettingsEditor delegate, @NotNull C configuration) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/impl/ui/facetType/DefaultFacetSettingsConfigurable", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/impl/ui/facetType/DefaultFacetSettingsConfigurable", "<init>"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/facet/impl/ui/facetType/DefaultFacetSettingsConfigurable", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/facet/impl/ui/facetType/DefaultFacetSettingsConfigurable", "<init>"));
        }
        this.myFacetType = facetType;
        this.myProject = project;
        this.myDelegate = delegate;
        this.myConfiguration = configuration;
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"facet.defaults.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return this.myDelegate.getHelpTopic();
    }

    public JComponent createComponent() {
        return this.myDelegate.createComponent();
    }

    public boolean isModified() {
        return this.myDelegate.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myDelegate.isModified()) {
            this.myDelegate.apply();
            ProjectFacetManager.getInstance((Project)this.myProject).setDefaultConfiguration(this.myFacetType, this.myConfiguration);
        }
    }

    public void reset() {
        this.myDelegate.reset();
    }

    public void disposeUIResources() {
        this.myDelegate.disposeUIResources();
    }
}

