/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.impl.FacetLoadingErrorDescription;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.facet.impl.FacetModelImpl;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacetType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@State(name="FacetManager", storages={@Storage(file="$MODULE_FILE$")})
public class FacetManagerImpl
extends FacetManager
implements ModuleComponent,
PersistentStateComponent<FacetManagerState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.FacetManagerImpl");
    @NonNls
    public static final String COMPONENT_NAME = "FacetManager";
    private final Module myModule;
    private final FacetTypeRegistry myFacetTypeRegistry;
    private final FacetManagerModel myModel = new FacetManagerModel();
    private boolean myInsideCommit = false;
    private final MessageBus myMessageBus;
    private boolean myModuleAdded;

    public FacetManagerImpl(Module module, MessageBus messageBus, FacetTypeRegistry facetTypeRegistry) {
        this.myModule = module;
        this.myMessageBus = messageBus;
        this.myFacetTypeRegistry = facetTypeRegistry;
    }

    @NotNull
    public ModifiableFacetModel createModifiableModel() {
        FacetModelImpl model = new FacetModelImpl(this);
        model.addFacetsFromManager();
        FacetModelImpl facetModelImpl = model;
        if (facetModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "createModifiableModel"));
        }
        return facetModelImpl;
    }

    @NotNull
    public Facet[] getAllFacets() {
        Facet[] facetArray = this.myModel.getAllFacets();
        if (facetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getAllFacets"));
        }
        return facetArray;
    }

    @Nullable
    public <F extends Facet> F getFacetByType(FacetTypeId<F> typeId) {
        return this.myModel.getFacetByType(typeId);
    }

    @Nullable
    public <F extends Facet> F findFacet(FacetTypeId<F> type, String name) {
        return this.myModel.findFacet(type, name);
    }

    @Nullable
    public <F extends Facet> F getFacetByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        if (underlyingFacet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/FacetManagerImpl", "getFacetByType"));
        }
        return this.myModel.getFacetByType(underlyingFacet, typeId);
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        if (underlyingFacet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/FacetManagerImpl", "getFacetsByType"));
        }
        Collection<F> collection = this.myModel.getFacetsByType(underlyingFacet, typeId);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getFacetsByType"));
        }
        return collection;
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection<F> collection = this.myModel.getFacetsByType(typeId);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getFacetsByType"));
        }
        return collection;
    }

    @NotNull
    public Facet[] getSortedFacets() {
        Facet[] facetArray = this.myModel.getSortedFacets();
        if (facetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getSortedFacets"));
        }
        return facetArray;
    }

    @NotNull
    public String getFacetName(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/FacetManagerImpl", "getFacetName"));
        }
        String string = this.myModel.getFacetName(facet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getFacetName"));
        }
        return string;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> F createFacet(@NotNull FacetType<F, C> type, @NotNull String name, @NotNull C cofiguration, @Nullable Facet underlying) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        if (cofiguration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        Facet facet = type.createFacet(this.myModule, name, cofiguration, underlying);
        FacetManagerImpl.assertTrue(facet.getModule() == this.myModule, facet, "module");
        FacetManagerImpl.assertTrue(facet.getConfiguration() == cofiguration, facet, "configuration");
        FacetManagerImpl.assertTrue(Comparing.equal((String)facet.getName(), (String)name), facet, "name");
        FacetManagerImpl.assertTrue(facet.getUnderlyingFacet() == underlying, facet, "underlyingFacet");
        Facet facet2 = facet;
        if (facet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        return (F)facet2;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> F createFacet(@NotNull FacetType<F, C> type, @NotNull String name, @Nullable Facet underlying) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        FacetConfiguration configuration = ProjectFacetManager.getInstance((Project)this.myModule.getProject()).createDefaultConfiguration(type);
        F f = this.createFacet(type, name, configuration, underlying);
        if (f == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        return f;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> F addFacet(@NotNull FacetType<F, C> type, @NotNull String name, @Nullable Facet underlying) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/FacetManagerImpl", "addFacet"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/FacetManagerImpl", "addFacet"));
        }
        ModifiableFacetModel model = this.createModifiableModel();
        F facet = this.createFacet(type, name, underlying);
        model.addFacet(facet);
        model.commit();
        F f = facet;
        if (f == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "addFacet"));
        }
        return f;
    }

    private static void assertTrue(boolean value, Facet facet, String parameter) {
        if (!value) {
            LOG.error("Facet type " + facet.getType().getClass().getName() + " violates the contract of FacetType.createFacet method about '" + parameter + "' parameter");
        }
    }

    private void addFacets(List<FacetState> facetStates, Facet underlyingFacet, ModifiableFacetModel model) {
        for (FacetState child : facetStates) {
            FacetType actualUnderlyingType;
            String typeId = child.getFacetType();
            if (typeId == null) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.facet.type.isn.t.specified", (Object[])new Object[0]));
                continue;
            }
            FacetType type = this.myFacetTypeRegistry.findFacetType(typeId);
            if (type == null) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.unknown.facet.type.0", (Object[])new Object[]{typeId}), typeId);
                continue;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            if (!type.isSuitableModuleType(moduleType)) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.facets.are.not.allowed.in.1", (Object[])new Object[]{type.getPresentableName(), moduleType.getName()}));
                continue;
            }
            FacetType expectedUnderlyingType = null;
            FacetTypeId underlyingTypeId = type.getUnderlyingFacetType();
            if (underlyingTypeId != null) {
                expectedUnderlyingType = this.myFacetTypeRegistry.findFacetType(underlyingTypeId);
            }
            FacetType facetType = actualUnderlyingType = underlyingFacet != null ? underlyingFacet.getType() : null;
            if (expectedUnderlyingType != null) {
                if (!expectedUnderlyingType.equals(actualUnderlyingType)) {
                    this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.facet.must.be.placed.under.1.facet", (Object[])new Object[]{type.getPresentableName(), expectedUnderlyingType.getPresentableName()}));
                    continue;
                }
            } else if (actualUnderlyingType != null) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.cannot.be.placed.under.1", (Object[])new Object[]{type.getPresentableName(), actualUnderlyingType.getPresentableName()}));
                continue;
            }
            try {
                this.addFacet(type, child, underlyingFacet, model);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.cannot.load.facet.condiguration.0", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model, Facet underlyingFacet, String errorMessage) {
        this.addInvalidFacet(state, model, underlyingFacet, errorMessage, null);
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model, Facet underlyingFacet, String errorMessage, String typeId) {
        InvalidFacetManager invalidFacetManager = InvalidFacetManager.getInstance(this.myModule.getProject());
        InvalidFacetType type = InvalidFacetType.getInstance();
        InvalidFacetConfiguration configuration = new InvalidFacetConfiguration(state, errorMessage);
        InvalidFacet facet = this.createFacet(type, StringUtil.notNullize((String)state.getName()), configuration, underlyingFacet);
        model.addFacet((Facet)facet);
        if (!invalidFacetManager.isIgnored(facet)) {
            FacetLoadingErrorDescription description = new FacetLoadingErrorDescription(facet);
            ProjectLoadingErrorsNotifier.getInstance(this.myModule.getProject()).registerError(description);
            if (typeId != null) {
                UnknownFeaturesCollector.getInstance(this.myModule.getProject()).registerUnknownFeature("com.intellij.facetType", typeId);
            }
        }
    }

    private <C extends FacetConfiguration> void addFacet(FacetType<?, C> type, FacetState state, Facet underlyingFacet, ModifiableFacetModel model) throws InvalidDataException {
        if (type.isOnlyOneFacetAllowed() && (underlyingFacet == null && !model.getFacetsByType(type.getId()).isEmpty() || underlyingFacet != null && !model.getFacetsByType(underlyingFacet, type.getId()).isEmpty())) {
            LOG.info("'" + state.getName() + "' facet removed from module " + this.myModule.getName() + ", because only one " + type.getPresentableName() + " facet allowed");
            return;
        }
        FacetConfiguration configuration = type.createDefaultConfiguration();
        Element config = state.getConfiguration();
        FacetUtil.loadFacetConfiguration(configuration, config);
        String name = state.getName();
        Object facet = this.createFacet(type, name, configuration, underlyingFacet);
        if (facet instanceof JDOMExternalizable) {
            ((JDOMExternalizable)facet).readExternal(config);
        }
        model.addFacet(facet);
        this.addFacets(state.getSubFacets(), (Facet)facet, model);
    }

    public void loadState(FacetManagerState state) {
        FacetModelImpl model = new FacetModelImpl(this);
        this.addFacets(state.getFacets(), null, model);
        this.commit(model, false);
    }

    public FacetManagerState getState() {
        FacetManagerState managerState = new FacetManagerState();
        Facet[] facets = this.getSortedFacets();
        HashMap<Facet, List<FacetState>> states = new HashMap<Facet, List<FacetState>>();
        states.put(null, managerState.getFacets());
        for (Facet facet : facets) {
            FacetState facetState;
            Facet underlyingFacet = facet.getUnderlyingFacet();
            List parent = (List)states.get(underlyingFacet);
            if (facet instanceof InvalidFacet) {
                facetState = ((InvalidFacetConfiguration)((InvalidFacet)facet).getConfiguration()).getFacetState();
            } else {
                Element config;
                block5: {
                    facetState = new FacetState();
                    facetState.setFacetType(facet.getType().getStringId());
                    facetState.setName(facet.getName());
                    try {
                        FacetConfiguration configuration = facet.getConfiguration();
                        config = FacetUtil.saveFacetConfiguration(configuration);
                        if (!(facet instanceof JDOMExternalizable)) break block5;
                        ((JDOMExternalizable)facet).writeExternal(config);
                    }
                    catch (WriteExternalException e) {
                        continue;
                    }
                }
                facetState.setConfiguration(config);
            }
            parent.add(facetState);
            states.put(facet, facetState.getSubFacets());
        }
        return managerState;
    }

    public void commit(ModifiableFacetModel model) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.commit(model, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(ModifiableFacetModel model, boolean fireEvents) {
        LOG.assertTrue(!this.myInsideCommit, (Object)"Recursive commit");
        HashSet<Facet> toRemove = new HashSet<Facet>(Arrays.asList(this.getAllFacets()));
        ArrayList<Facet> toAdd = new ArrayList<Facet>();
        ArrayList<FacetRenameInfo> toRename = new ArrayList<FacetRenameInfo>();
        FacetManagerListener publisher = (FacetManagerListener)this.myMessageBus.syncPublisher(FACETS_TOPIC);
        try {
            this.myInsideCommit = true;
            for (Facet facet : model.getAllFacets()) {
                boolean isNew;
                boolean bl = isNew = !toRemove.remove(facet);
                if (!isNew) continue;
                toAdd.add(facet);
            }
            ArrayList<Facet> newFacets = new ArrayList<Facet>();
            for (Facet facet : this.getAllFacets()) {
                if (toRemove.contains(facet)) continue;
                newFacets.add(facet);
            }
            newFacets.addAll(toAdd);
            for (Facet facet : newFacets) {
                String newName = model.getNewName(facet);
                if (newName == null || newName.equals(facet.getName())) continue;
                toRename.add(new FacetRenameInfo(facet, facet.getName(), newName));
            }
            if (fireEvents) {
                for (Facet facet : toAdd) {
                    publisher.beforeFacetAdded(facet);
                }
                for (Facet facet : toRemove) {
                    publisher.beforeFacetRemoved(facet);
                }
                for (FacetRenameInfo info : toRename) {
                    publisher.beforeFacetRenamed(info.myFacet);
                }
            }
            for (FacetRenameInfo info : toRename) {
                info.myFacet.setName(info.myNewName);
            }
            this.myModel.setAllFacets(newFacets.toArray(new Facet[newFacets.size()]));
        }
        finally {
            this.myInsideCommit = false;
        }
        if (this.myModuleAdded) {
            for (Facet facet : toAdd) {
                facet.initFacet();
            }
        }
        for (Facet facet : toRemove) {
            Disposer.dispose((Disposable)facet);
        }
        if (fireEvents) {
            for (Facet facet : toAdd) {
                publisher.facetAdded(facet);
            }
            for (Facet facet : toRemove) {
                publisher.facetRemoved(facet);
            }
            for (FacetRenameInfo info : toRename) {
                publisher.facetRenamed(info.myFacet, info.myOldName);
            }
        }
        for (Facet facet : toAdd) {
            FacetType type;
            Module module = facet.getModule();
            if (!module.equals(this.myModule)) {
                LOG.error(facet + " is created for module " + module + " but added to module " + this.myModule);
            }
            if (!(type = facet.getType()).isOnlyOneFacetAllowed()) continue;
            if (type.getUnderlyingFacetType() == null) {
                Collection facets = this.getFacetsByType(type.getId());
                if (facets.size() <= 1) continue;
                LOG.error("Only one '" + type.getPresentableName() + "' facet per module allowed, but " + facets.size() + " facets found in module '" + this.myModule.getName() + "'");
                continue;
            }
            Facet underlyingFacet = facet.getUnderlyingFacet();
            LOG.assertTrue(underlyingFacet != null, (Object)("Underlying facet is not specifed for '" + facet.getName() + "'"));
            Collection facets = this.getFacetsByType(underlyingFacet, type.getId());
            if (facets.size() <= 1) continue;
            LOG.error("Only one '" + type.getPresentableName() + "' facet per parent facet allowed, but " + facets.size() + " sub-facets found in facet " + underlyingFacet.getName());
        }
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void moduleAdded() {
        if (this.myModuleAdded) {
            return;
        }
        for (Facet facet : this.getAllFacets()) {
            facet.initFacet();
        }
        this.myModuleAdded = true;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getComponentName"));
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private static class FacetRenameInfo {
        private final Facet myFacet;
        private final String myOldName;
        private final String myNewName;

        public FacetRenameInfo(Facet facet, String oldName, String newName) {
            this.myFacet = facet;
            this.myOldName = oldName;
            this.myNewName = newName;
        }
    }

    private static class FacetManagerModel
    extends FacetModelBase {
        private Facet[] myAllFacets = Facet.EMPTY_ARRAY;

        private FacetManagerModel() {
        }

        @NotNull
        public Facet[] getAllFacets() {
            if (this.myAllFacets == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl$FacetManagerModel", "getAllFacets"));
            }
            return this.myAllFacets;
        }

        public void setAllFacets(Facet[] allFacets) {
            this.myAllFacets = allFacets;
            this.facetsChanged();
        }
    }
}

