/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgramParametersConfigurator {
    public void configureConfiguration(SimpleProgramParameters parameters, CommonProgramRunConfigurationParameters configuration) {
        Project project = configuration.getProject();
        Module module = this.getModule(configuration);
        parameters.getProgramParametersList().addParametersString(this.expandPath(configuration.getProgramParameters(), module, project));
        parameters.setWorkingDirectory(this.getWorkingDir(configuration, project, module));
        parameters.setupEnvs(configuration.getEnvs(), configuration.isPassParentEnvs());
        if (parameters.getEnv() != null) {
            HashMap expanded = new HashMap();
            for (Map.Entry each : parameters.getEnv().entrySet()) {
                expanded.put(each.getKey(), this.expandPath((String)each.getValue(), module, project));
            }
            parameters.setEnv(expanded);
        }
    }

    @Nullable
    public String getWorkingDir(CommonProgramRunConfigurationParameters configuration, Project project, Module module) {
        String workingDirectory = configuration.getWorkingDirectory();
        String defaultWorkingDir = this.getDefaultWorkingDir(project);
        if (workingDirectory == null || workingDirectory.trim().length() == 0) {
            workingDirectory = defaultWorkingDir;
        }
        if (workingDirectory == null) {
            return null;
        }
        if (!FileUtil.isAbsolute((String)(workingDirectory = this.expandPath(workingDirectory, module, project))) && defaultWorkingDir != null) {
            if ("$MODULE_DIR$".equals(workingDirectory)) {
                return defaultWorkingDir;
            }
            workingDirectory = defaultWorkingDir + "/" + workingDirectory;
        }
        return workingDirectory;
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ProgramParametersConfigurator", "getDefaultWorkingDir"));
        }
        return PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
    }

    public void checkWorkingDirectoryExist(CommonProgramRunConfigurationParameters configuration, Project project, Module module) throws RuntimeConfigurationWarning {
        String workingDir = this.getWorkingDir(configuration, project, module);
        if (workingDir == null) {
            throw new RuntimeConfigurationWarning("Working directory is null for project '" + project.getName() + "' (" + project.getBasePath() + ")" + ", module '" + module.getName() + "' (" + module.getModuleFilePath() + ")");
        }
        if (!new File(workingDir).exists()) {
            throw new RuntimeConfigurationWarning("Working directory '" + workingDir + "' doesn't exist");
        }
    }

    protected String expandPath(String path, Module module, Project project) {
        path = PathMacroManager.getInstance((ComponentManager)project).expandPath(path);
        if (module != null) {
            path = PathMacroManager.getInstance((ComponentManager)module).expandPath(path);
        }
        return path;
    }

    @Nullable
    protected Module getModule(CommonProgramRunConfigurationParameters configuration) {
        if (configuration instanceof ModuleBasedConfiguration) {
            return ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
        }
        return null;
    }
}

