/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayout {
    public static final Key<Integer> DEFAULT_INDEX = Key.create((String)"RunnerLayoutDefaultIndex");
    public static final Key<Integer> DROP_INDEX = Key.create((String)"RunnerLayoutDropIndex");
    private final String myID;
    protected Map<String, ViewImpl> myViews;
    private final Map<String, ViewImpl.Default> myDefaultViews;
    protected Set<TabImpl> myTabs;
    private final Map<Integer, TabImpl.Default> myDefaultTabs;
    protected General myGeneral;
    private final Map<String, Pair<String, LayoutAttractionPolicy>> myDefaultFocus;

    public RunnerLayout(@NotNull String ID2) {
        if (ID2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "<init>"));
        }
        this.myViews = new HashMap<String, ViewImpl>();
        this.myDefaultViews = new HashMap<String, ViewImpl.Default>();
        this.myTabs = new TreeSet<TabImpl>(new Comparator<TabImpl>(){

            @Override
            public int compare(TabImpl o1, TabImpl o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        this.myDefaultTabs = new HashMap<Integer, TabImpl.Default>();
        this.myGeneral = new General();
        this.myDefaultFocus = new HashMap<String, Pair<String, LayoutAttractionPolicy>>();
        this.myID = ID2;
    }

    @Nullable
    public String getDefaultDisplayName(int defaultIndex) {
        TabImpl.Default tab = this.myDefaultTabs.get(defaultIndex);
        return tab != null ? tab.myDisplayName : null;
    }

    @NotNull
    public TabImpl getOrCreateTab(int index) {
        TabImpl tab = this.findTab(index);
        if (tab != null) {
            TabImpl tabImpl = tab;
            if (tabImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateTab"));
            }
            return tabImpl;
        }
        TabImpl tabImpl = tab = this.createNewTab(index);
        if (tabImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateTab"));
        }
        return tabImpl;
    }

    @NotNull
    private TabImpl createNewTab(int index) {
        TabImpl.Default defaultTab = this.getOrCreateDefaultTab(index);
        TabImpl tab = defaultTab.createTab();
        this.myTabs.add(tab);
        TabImpl tabImpl = tab;
        if (tabImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "createNewTab"));
        }
        return tabImpl;
    }

    @NotNull
    private TabImpl.Default getOrCreateDefaultTab(int index) {
        TabImpl.Default tab = this.myDefaultTabs.get(index);
        if (tab == null) {
            tab = new TabImpl.Default(index, null, null);
            this.myDefaultTabs.put(index, tab);
        }
        TabImpl.Default default_ = tab;
        if (default_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateDefaultTab"));
        }
        return default_;
    }

    @NotNull
    public TabImpl createNewTab() {
        int index = 0;
        for (TabImpl each : this.myTabs) {
            if (!this.isUsed(each)) {
                TabImpl tabImpl = each;
                if (tabImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "createNewTab"));
                }
                return tabImpl;
            }
            if (each.getIndex() >= Integer.MAX_VALUE) break;
            index = each.getIndex() + 1;
        }
        TabImpl tabImpl = this.createNewTab(index);
        if (tabImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "createNewTab"));
        }
        return tabImpl;
    }

    private boolean isUsed(@NotNull TabImpl tab) {
        if (tab == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "isUsed"));
        }
        for (ViewImpl each : this.myViews.values()) {
            if (each.getTab() != tab) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected TabImpl findTab(int index) {
        for (TabImpl each : this.myTabs) {
            if (index != each.getIndex()) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public Element getState() {
        Element element = this.write(new Element("layout"));
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getState"));
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "loadState"));
        }
        this.read(state);
    }

    @NotNull
    public Element read(@NotNull Element parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "read"));
        }
        List tabs = parentNode.getChildren(StringUtil.getShortName((String)TabImpl.class.getName()));
        for (Object eachTabElement : tabs) {
            TabImpl eachTab = new TabImpl((Element)eachTabElement);
            this.getOrCreateTab(eachTab.getIndex()).read((Element)eachTabElement);
        }
        List views = parentNode.getChildren(StringUtil.getShortName((String)ViewImpl.class.getName()));
        for (Object content : views) {
            ViewImpl state = new ViewImpl(this, (Element)content);
            this.myViews.put(state.getID(), state);
        }
        XmlSerializer.deserializeInto((Object)this.myGeneral, (Element)parentNode.getChild(StringUtil.getShortName((String)this.myGeneral.getClass().getName(), (char)'$')));
        Element element = parentNode;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "read"));
        }
        return element;
    }

    @NotNull
    public Element write(@NotNull Element parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "write"));
        }
        for (ViewImpl eachState : this.myViews.values()) {
            eachState.write(parentNode);
        }
        for (TabImpl eachTab : this.myTabs) {
            if (!this.isUsed(eachTab)) continue;
            eachTab.write(parentNode);
        }
        parentNode.addContent(XmlSerializer.serialize((Object)this.myGeneral));
        Element element = parentNode;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "write"));
        }
        return element;
    }

    public void resetToDefault() {
        this.myViews.clear();
        this.myTabs.clear();
    }

    public boolean isToolbarHorizontal() {
        return false;
    }

    public void setToolbarHorizontal(boolean horizontal) {
        this.myGeneral.horizontalToolbar = horizontal;
    }

    @NotNull
    public ViewImpl getStateFor(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getStateFor"));
        }
        ViewImpl viewImpl = this.getOrCreateView(RunnerLayout.getOrCreateContentId(content));
        if (viewImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getStateFor"));
        }
        return viewImpl;
    }

    public void clearStateFor(@NotNull Content content) {
        Tab tab;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "clearStateFor"));
        }
        ViewImpl view = this.myViews.remove(RunnerLayout.getOrCreateContentId(content));
        if (view != null && (tab = view.getTab()) instanceof TabImpl) {
            this.myTabs.remove(tab);
        }
    }

    @NotNull
    private static String getOrCreateContentId(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateContentId"));
        }
        String id = (String)content.getUserData(ViewImpl.ID);
        if (id == null) {
            id = "UnknownView-" + content.getDisplayName();
            content.putUserData(ViewImpl.ID, (Object)id);
        }
        String string = id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateContentId"));
        }
        return string;
    }

    @NotNull
    private ViewImpl getOrCreateView(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateView"));
        }
        if (this.myViews.containsKey(id)) {
            ViewImpl viewImpl = this.myViews.get(id);
            if (viewImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateView"));
            }
            return viewImpl;
        }
        ViewImpl.Default defaultView = this.getOrCreateDefault(id);
        ViewImpl view = defaultView.createView(this);
        this.myViews.put(id, view);
        ViewImpl viewImpl = view;
        if (viewImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateView"));
        }
        return viewImpl;
    }

    @NotNull
    private ViewImpl.Default getOrCreateDefault(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateDefault"));
        }
        if (this.myDefaultViews.containsKey(id)) {
            ViewImpl.Default default_ = this.myDefaultViews.get(id);
            if (default_ == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateDefault"));
            }
            return default_;
        }
        ViewImpl.Default default_ = this.setDefault(id, Integer.MAX_VALUE, PlaceInGrid.bottom, false);
        if (default_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getOrCreateDefault"));
        }
        return default_;
    }

    @NotNull
    public TabImpl.Default setDefault(int tabID, String displayName, Icon icon) {
        TabImpl.Default tab = new TabImpl.Default(tabID, displayName, icon);
        this.myDefaultTabs.put(tabID, tab);
        TabImpl.Default default_ = tab;
        if (default_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "setDefault"));
        }
        return default_;
    }

    @NotNull
    public ViewImpl.Default setDefault(@NotNull String id, int tabIndex, @NotNull PlaceInGrid placeInGrid, boolean isMinimized) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "setDefault"));
        }
        if (placeInGrid == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/ui/layout/impl/RunnerLayout", "setDefault"));
        }
        ViewImpl.Default view = new ViewImpl.Default(id, tabIndex, placeInGrid, isMinimized);
        this.myDefaultViews.put(id, view);
        ViewImpl.Default default_ = view;
        if (default_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "setDefault"));
        }
        return default_;
    }

    @NotNull
    public PlaceInGrid getDefaultGridPlace(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getDefaultGridPlace"));
        }
        PlaceInGrid placeInGrid = this.getOrCreateDefault(RunnerLayout.getOrCreateContentId(content)).getPlaceInGrid();
        if (placeInGrid == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getDefaultGridPlace"));
        }
        return placeInGrid;
    }

    public boolean isToFocus(String id, @NotNull String condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ui/layout/impl/RunnerLayout", "isToFocus"));
        }
        return Comparing.equal((String)id, (String)this.getToFocus(condition));
    }

    public void setToFocus(String id, @NotNull String condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ui/layout/impl/RunnerLayout", "setToFocus"));
        }
        this.myGeneral.focusOnCondition.put(condition, id);
    }

    public void setDefaultToFocus(@NotNull String id, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "setDefaultToFocus"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ui/layout/impl/RunnerLayout", "setDefaultToFocus"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/ui/layout/impl/RunnerLayout", "setDefaultToFocus"));
        }
        this.myDefaultFocus.put(condition, (Pair<String, LayoutAttractionPolicy>)Pair.create((Object)id, (Object)policy));
    }

    @Nullable
    public String getToFocus(@NotNull String condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getToFocus"));
        }
        return this.myGeneral.focusOnCondition.containsKey(condition) ? this.myGeneral.focusOnCondition.get(condition) : (this.myDefaultFocus.containsKey(condition) ? (String)this.myDefaultFocus.get(condition).getFirst() : null);
    }

    @NotNull
    public LayoutAttractionPolicy getAttractionPolicy(@NotNull String condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getAttractionPolicy"));
        }
        Pair<String, LayoutAttractionPolicy> pair = this.myDefaultFocus.get(condition);
        Object object = pair == null ? new LayoutAttractionPolicy.FocusOnce() : (LayoutAttractionPolicy)pair.getSecond();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayout", "getAttractionPolicy"));
        }
        return object;
    }

    public static class General {
        public volatile boolean horizontalToolbar = false;
        public volatile Map<String, String> focusOnCondition = new HashMap<String, String>();
    }
}

