/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBRunnerTabs
extends JBTabsImpl {
    public JBRunnerTabs(@Nullable Project project, ActionManager actionManager, IdeFocusManager focusManager, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/ui/layout/impl/JBRunnerTabs", "<init>"));
        }
        super(project, actionManager, focusManager, parent);
    }

    public boolean useSmallLabels() {
        return true;
    }

    public boolean hasUnderline() {
        return true;
    }

    protected void paintFirstGhost(Graphics2D g2d) {
    }

    protected void paintLastGhost(Graphics2D g2d) {
    }

    protected void doPaintInactive(Graphics2D g2d, boolean leftGhostExists, TabLabel label, Rectangle effectiveBounds, boolean rightGhostExists, int row, int column) {
        Insets insets = this.getTabsBorder().getEffectiveBorder();
        boolean dark = UIUtil.isUnderDarcula();
        int _x = effectiveBounds.x + insets.left;
        int _y = effectiveBounds.y + insets.top + 3;
        int _width = effectiveBounds.width - insets.left - insets.right;
        int _height = effectiveBounds.height - insets.top - insets.bottom - 3;
        _height -= 4;
        if (dark) {
            g2d.setPaint(UIUtil.getGradientPaint((float)_x, (float)_y, (Color)ColorUtil.shift((Color)UIUtil.getListBackground(), (double)1.3), (float)_x, (float)(_y + effectiveBounds.height), (Color)UIUtil.getPanelBackground()));
            g2d.fillRect(_x, _y, _width, _height);
            g2d.setColor(Gray._0.withAlpha(50));
        } else {
            g2d.setPaint(UIUtil.getGradientPaint((float)_x, (float)_y, (Color)new Color(255, 255, 255, 180), (float)_x, (float)(_y + effectiveBounds.height), (Color)new Color(255, 255, 255, 100)));
            g2d.fillRect(_x, _y, _width, _height);
            g2d.setColor(new Color(255, 255, 255, 100));
            g2d.drawRect(_x, _y, _width - 1, _height - 1);
        }
    }

    protected void doPaintBackground(Graphics2D g2d, Rectangle clip) {
        g2d.setColor(UIUtil.getPanelBackground());
        g2d.fill(clip);
        g2d.setColor(new Color(0, 0, 0, 50));
        g2d.fill(clip);
        List visibleInfos = this.getVisibleInfos();
        Insets insets = this.getTabsBorder().getEffectiveBorder();
        int maxOffset = 0;
        int maxLength = 0;
        for (int i = visibleInfos.size() - 1; i >= 0; --i) {
            TabInfo visibleInfo = (TabInfo)visibleInfos.get(i);
            TabLabel tabLabel = (TabLabel)this.myInfo2Label.get(visibleInfo);
            Rectangle r = tabLabel.getBounds();
            if (r.width == 0 || r.height == 0) continue;
            maxOffset = r.x + r.width;
            maxLength = r.height;
            break;
        }
        Rectangle r2 = this.getBounds();
        int y = r2.y + insets.top;
        int height = maxLength - insets.top - insets.bottom;
        Rectangle rectangle = new Rectangle(++maxOffset, y, r2.width - maxOffset - insets.left - insets.right, height -= 4);
        g2d.setPaint(UIUtil.getPanelBackground());
        g2d.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        g2d.fillRect(0, 0, rectangle.x + rectangle.width, 3);
        g2d.fillRect(2, maxLength, this.getSize().width, this.getSize().height);
        g2d.drawLine(0, 0, 0, this.getSize().height);
    }

    protected void paintSelectionAndBorder(Graphics2D g2d) {
        if (this.getSelectedInfo() == null) {
            return;
        }
        boolean dark = UIUtil.isUnderDarcula();
        Gray col = dark ? ColorUtil.shift((Color)UIUtil.getListBackground(), (double)1.6) : Gray._255;
        Color panelBg = dark ? ColorUtil.shift((Color)UIUtil.getPanelBackground(), (double)1.3) : UIUtil.getPanelBackground();
        TabLabel label = this.getSelectedLabel();
        Rectangle r = label.getBounds();
        r = new Rectangle(r.x, r.y + 3, r.width, r.height - 3);
        JBTabsImpl.ShapeInfo selectedShape = this._computeSelectedLabelShape(r);
        Insets insets = this.getTabsBorder().getEffectiveBorder();
        Insets i = selectedShape.path.transformInsets(insets);
        int _x = r.x;
        int _y = r.y;
        int _height = r.height;
        if (!this.isHideTabs()) {
            g2d.setPaint(UIUtil.getGradientPaint((float)_x, (float)_y, (Color)col, (float)_x, (float)(_y + _height - 3), (Color)panelBg));
            g2d.fill(selectedShape.fillPath.getShape());
            g2d.setColor(ColorUtil.toAlpha((Color)col, (int)180));
            g2d.draw(selectedShape.fillPath.getShape());
            g2d.draw(selectedShape.labelPath.transformLine(selectedShape.labelPath.getMaxX() - selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getY() + selectedShape.labelPath.deltaY(1), selectedShape.labelPath.getMaxX() - selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
        }
        if (UIUtil.isUnderDarcula()) {
            return;
        }
        g2d.setColor(panelBg);
        g2d.fillRect(2, selectedShape.labelPath.getMaxY() - 2, selectedShape.path.getMaxX() - 2, 3);
        g2d.drawLine(1, selectedShape.labelPath.getMaxY(), 1, this.getHeight() - 1);
        g2d.drawLine(selectedShape.path.getMaxX() - 1, selectedShape.labelPath.getMaxY() - 4, selectedShape.path.getMaxX() - 1, this.getHeight() - 1);
        if (this.isHideTabs()) {
            return;
        }
        g2d.setColor(Gray._0.withAlpha(50));
        g2d.drawLine(1, selectedShape.labelPath.getMaxY(), 1, this.getHeight() - 1);
        g2d.drawLine(selectedShape.path.getMaxX() - 1, selectedShape.labelPath.getMaxY() - 4, selectedShape.path.getMaxX() - 1, this.getHeight() - 1);
    }

    public Color getBackground() {
        return UIUtil.isUnderDarcula() ? UIUtil.getPanelBackground() : Gray._142;
    }

    protected JBTabsImpl.ShapeInfo _computeSelectedLabelShape(Rectangle r) {
        JBTabsImpl.ShapeInfo shape = new JBTabsImpl.ShapeInfo();
        shape.path = this.getEffectiveLayout().createShapeTransform(this.getSize());
        shape.insets = shape.path.transformInsets(this.getLayoutInsets());
        shape.labelPath = shape.path.createTransform(r);
        shape.labelBottomY = shape.labelPath.getMaxY() - shape.labelPath.deltaY(3);
        shape.labelTopY = shape.labelPath.getY() + shape.labelPath.deltaY(1);
        shape.labelLeftX = shape.labelPath.getX();
        shape.labelRightX = shape.labelPath.getMaxX() - shape.labelPath.deltaX(1);
        int leftX = shape.insets.left;
        shape.path.moveTo(leftX, shape.labelBottomY);
        shape.path.lineTo(shape.labelLeftX, shape.labelBottomY);
        shape.path.lineTo(shape.labelLeftX, shape.labelTopY);
        shape.path.lineTo(shape.labelRightX, shape.labelTopY);
        shape.path.lineTo(shape.labelRightX, shape.labelBottomY);
        int lastX = shape.path.getWidth() - shape.path.deltaX(shape.insets.right);
        shape.path.lineTo(lastX, shape.labelBottomY);
        shape.path.lineTo(lastX, shape.labelBottomY + shape.labelPath.deltaY(3));
        shape.path.lineTo(leftX, shape.labelBottomY + shape.labelPath.deltaY(3));
        shape.path.closePath();
        shape.fillPath = shape.path.copy();
        return shape;
    }

    public int getToolbarInset() {
        return 8;
    }

    public boolean shouldAddToGlobal(Point point) {
        TabLabel label = this.getSelectedLabel();
        if (label == null || point == null) {
            return true;
        }
        Rectangle bounds = label.getBounds();
        return point.y <= bounds.y + bounds.height;
    }

    public Rectangle layout(JComponent c, Rectangle bounds) {
        if (c instanceof JBTabsImpl.Toolbar) {
            bounds.height -= 5;
            return super.layout(c, bounds);
        }
        if (c instanceof GridImpl) {
            --bounds.x;
            ++bounds.width;
            if (!this.isHideTabs()) {
                --bounds.y;
                ++bounds.height;
            }
        }
        return super.layout(c, bounds);
    }

    public void processDropOver(TabInfo over, RelativePoint relativePoint) {
        Point point = relativePoint.getPoint((Component)this.getComponent());
        this.myShowDropLocation = this.shouldAddToGlobal(point);
        super.processDropOver(over, relativePoint);
        for (Map.Entry entry : this.myInfo2Label.entrySet()) {
            TabLabel label = (TabLabel)entry.getValue();
            if (!label.getBounds().contains(point) || this.myDropInfo == entry.getKey()) continue;
            this.select((TabInfo)entry.getKey(), false);
            break;
        }
    }

    protected TabLabel createTabLabel(TabInfo info) {
        return new MyTabLabel(this, info);
    }

    private static class MyTabLabel
    extends TabLabel {
        public MyTabLabel(JBTabsImpl tabs, TabInfo info) {
            super(tabs, info);
        }

        public void apply(UiDecorator.UiDecoration decoration) {
            this.setBorder(new EmptyBorder(5, 5, 7, 5));
        }

        public void setTabActionsAutoHide(boolean autoHide) {
            super.setTabActionsAutoHide(autoHide);
            this.apply(null);
        }

        public void setTabActions(ActionGroup group) {
            super.setTabActions(group);
            if (this.myActionPanel != null) {
                JComponent wrapper = (JComponent)this.myActionPanel.getComponent(0);
                wrapper.remove(0);
                wrapper.add(Box.createHorizontalStrut(6), "West");
            }
        }

        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            result.height += 4;
            return result;
        }
    }
}

