/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.LvcsHelper;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeBuilder;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeStructure;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.PropagateSelectionHandler;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerToolbarPanel;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.sm.runner.ui.statistics.StatisticsPanel;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.testframework.ui.TestsProgressAnimator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestRunnerResultsForm
extends TestResultsPanel
implements TestFrameworkRunningModel,
TestResultsViewer,
SMTRunnerEventsListener {
    @NonNls
    private static final String DEFAULT_SM_RUNNER_SPLITTER_PROPERTY = "SMTestRunner.Splitter.Proportion";
    public static final Color DARK_YELLOW = JBColor.YELLOW.darker();
    private SMTRunnerTestTreeView myTreeView;
    private TestsProgressAnimator myAnimator;
    private final SMTestProxy.SMRootTestProxy myTestsRootNode;
    private SMTRunnerTreeBuilder myTreeBuilder;
    private final TestConsoleProperties myConsoleProperties;
    private final List<TestResultsViewer.EventsListener> myEventListeners;
    private PropagateSelectionHandler myShowStatisticForProxyHandler;
    private final Project myProject;
    private int myTotalTestCount;
    private int myStartedTestCount;
    private int myFinishedTestCount;
    private int myFailedTestCount;
    private int myIgnoredTestCount;
    private long myStartTime;
    private long myEndTime;
    private StatisticsPanel myStatisticsPane;
    private String myCurrentCustomProgressCategory;
    private final Set<String> myMentionedCategories;
    private boolean myTestsRunning;

    public SMTestRunnerResultsForm(RunConfiguration runConfiguration, @NotNull JComponent console, TestConsoleProperties consoleProperties, ExecutionEnvironment environment) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "<init>"));
        }
        this(runConfiguration, console, AnAction.EMPTY_ARRAY, consoleProperties, environment, null);
    }

    public SMTestRunnerResultsForm(RunConfiguration runConfiguration, @NotNull JComponent console, AnAction[] consoleActions, TestConsoleProperties consoleProperties, ExecutionEnvironment environment, String splitterPropertyName) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "<init>"));
        }
        super(console, consoleActions, consoleProperties, environment, splitterPropertyName != null ? splitterPropertyName : DEFAULT_SM_RUNNER_SPLITTER_PROPERTY, 0.5f);
        this.myEventListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTotalTestCount = 0;
        this.myStartedTestCount = 0;
        this.myFinishedTestCount = 0;
        this.myFailedTestCount = 0;
        this.myIgnoredTestCount = 0;
        this.myMentionedCategories = new LinkedHashSet<String>();
        this.myTestsRunning = true;
        this.myConsoleProperties = consoleProperties;
        this.myProject = runConfiguration.getProject();
        this.myTestsRootNode = new SMTestProxy.SMRootTestProxy();
    }

    @Override
    public void initUI() {
        super.initUI();
        KeyStroke shiftEnterKey = KeyStroke.getKeyStroke(10, 1);
        SMRunnerUtil.registerAsAction(shiftEnterKey, "show-statistics-for-test-proxy", new Runnable(){

            @Override
            public void run() {
                SMTestRunnerResultsForm.this.showStatisticsForSelectedProxy();
            }
        }, (JComponent)((Object)this.myTreeView));
    }

    @Override
    protected ToolbarPanel createToolbarPanel() {
        return new SMTRunnerToolbarPanel(this.myConsoleProperties, this.myEnvironment, this, this);
    }

    @Override
    protected JComponent createTestTreeView() {
        this.myTreeView = new SMTRunnerTestTreeView();
        this.myTreeView.setLargeModel(true);
        this.myTreeView.attachToModel(this);
        this.myTreeView.setTestResultsViewer(this);
        this.addTestsTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AbstractTestProxy selectedTest = SMTestRunnerResultsForm.this.getTreeView().getSelectedTest();
                if (selectedTest instanceof SMTestProxy) {
                    SMTestRunnerResultsForm.this.myStatisticsPane.selectProxy((SMTestProxy)selectedTest, this, false);
                }
            }
        });
        SMTRunnerTreeStructure structure = new SMTRunnerTreeStructure(this.myProject, this.myTestsRootNode);
        this.myTreeBuilder = new SMTRunnerTreeBuilder((JTree)((Object)this.myTreeView), structure);
        this.myTreeBuilder.setTestsComparator(TestConsoleProperties.SORT_ALPHABETICALLY.value((AbstractProperty.AbstractPropertyContainer)this.myProperties));
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
        this.myAnimator = new MyAnimator(this, this.myTreeBuilder);
        return this.myTreeView;
    }

    @Override
    protected JComponent createStatisticsPanel() {
        StatisticsPanel statisticsPane = new StatisticsPanel(this.myProject, this);
        statisticsPane.addPropagateSelectionListener(this.createSelectMeListener());
        this.setShowStatisticForProxyHandler(statisticsPane.createSelectMeListener());
        this.myStatisticsPane = statisticsPane;
        return this.myStatisticsPane.getContentPane();
    }

    public StatisticsPanel getStatisticsPane() {
        return this.myStatisticsPane;
    }

    public void addTestsTreeSelectionListener(TreeSelectionListener listener) {
        this.myTreeView.getSelectionModel().addTreeSelectionListener(listener);
    }

    @Override
    public void setShowStatisticForProxyHandler(PropagateSelectionHandler handler) {
        this.myShowStatisticForProxyHandler = handler;
    }

    @Override
    public void onTestingStarted(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestingStarted"));
        }
        this.myAnimator.setCurrentTestCase(this.myTestsRootNode);
        this.myStatusLine.setStatusColor(ColorProgressBar.GREEN);
        this.selectAndNotify(this.myTestsRootNode);
        this.myStartTime = System.currentTimeMillis();
        boolean printTestingStartedTime = true;
        if (this.myConsoleProperties instanceof SMTRunnerConsoleProperties) {
            printTestingStartedTime = ((SMTRunnerConsoleProperties)this.myConsoleProperties).isPrintTestingStartedTime();
        }
        if (printTestingStartedTime) {
            this.myTestsRootNode.addSystemOutput("Testing started at " + DateFormatUtil.formatTime((long)this.myStartTime) + " ...\n");
        }
        this.updateStatusLabel(false);
        this.fireOnTestingStarted();
    }

    @Override
    public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestingFinished"));
        }
        this.myEndTime = System.currentTimeMillis();
        if (this.myTotalTestCount == 0) {
            this.myTotalTestCount = this.myStartedTestCount;
            this.myStatusLine.setFraction(1.0);
        }
        this.updateStatusLabel(true);
        this.updateIconProgress();
        this.myAnimator.stopMovie();
        this.myTreeBuilder.updateFromRoot();
        LvcsHelper.addLabel(this);
        this.selectAndNotify(this.myTestsRootNode, new Runnable(){

            @Override
            public void run() {
                SMTestRunnerResultsForm.this.myTestsRunning = false;
            }
        });
        this.fireOnTestingFinished();
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.updateCountersAndProgressOnTestCount(count, false);
    }

    @Override
    public void onTestStarted(@NotNull SMTestProxy testProxy) {
        if (testProxy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestStarted"));
        }
        this.updateOnTestStarted(false);
        this._addTestOrSuite(testProxy);
        this.fireOnTestNodeAdded(testProxy);
    }

    @Override
    public void onTestFailed(@NotNull SMTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestFailed"));
        }
        this.updateOnTestFailed(false);
        this.updateIconProgress();
    }

    @Override
    public void onTestIgnored(@NotNull SMTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestIgnored"));
        }
        this.updateOnTestIgnored();
    }

    @Override
    public void onSuiteStarted(@NotNull SMTestProxy newSuite) {
        if (newSuite == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onSuiteStarted"));
        }
        this._addTestOrSuite(newSuite);
    }

    @Override
    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.myCurrentCustomProgressCategory = categoryName;
        this.updateCountersAndProgressOnTestCount(testCount, true);
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.updateOnTestStarted(true);
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.updateOnTestFailed(true);
    }

    @Override
    public void onTestFinished(@NotNull SMTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestFinished"));
        }
        this.updateOnTestFinished(false);
        this.updateIconProgress();
    }

    @Override
    public void onSuiteFinished(@NotNull SMTestProxy suite) {
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onSuiteFinished"));
        }
    }

    @Override
    public SMTestProxy.SMRootTestProxy getTestsRootNode() {
        return this.myTestsRootNode;
    }

    @Override
    public TestConsoleProperties getProperties() {
        return this.myConsoleProperties;
    }

    @Override
    public void setFilter(Filter filter) {
        SMTRunnerTreeStructure treeStructure = this.myTreeBuilder.getSMRunnerTreeStructure();
        treeStructure.setFilter(filter);
        this.myTreeBuilder.queueUpdate();
    }

    @Override
    public boolean isRunning() {
        return this.myTestsRunning;
    }

    @Override
    public TestTreeView getTreeView() {
        return this.myTreeView;
    }

    @Override
    public SMTRunnerTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    @Override
    public boolean hasTestSuites() {
        return this.getRoot().getChildren().size() > 0;
    }

    @Override
    @NotNull
    public AbstractTestProxy getRoot() {
        SMTestProxy.SMRootTestProxy sMRootTestProxy = this.myTestsRootNode;
        if (sMRootTestProxy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "getRoot"));
        }
        return sMRootTestProxy;
    }

    @Override
    public void selectAndNotify(AbstractTestProxy testProxy) {
        this.selectAndNotify(testProxy, null);
    }

    private void selectAndNotify(@Nullable AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        this.selectWithoutNotify(testProxy, onDone);
        this.showStatisticsForSelectedProxy(testProxy, false);
    }

    @Override
    public void addEventsListener(final TestResultsViewer.EventsListener listener) {
        this.myEventListeners.add(listener);
        this.addTestsTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SMTestProxy selectedProxy = (SMTestProxy)SMTestRunnerResultsForm.this.getTreeView().getSelectedTest();
                listener.onSelected(selectedProxy, SMTestRunnerResultsForm.this, SMTestRunnerResultsForm.this);
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myShowStatisticForProxyHandler = null;
        this.myEventListeners.clear();
        this.myStatisticsPane.doDispose();
    }

    @Override
    public void showStatisticsForSelectedProxy() {
        TestConsoleProperties.SHOW_STATISTICS.set((AbstractProperty.AbstractPropertyContainer)this.myProperties, (Object)true);
        AbstractTestProxy selectedProxy = this.myTreeView.getSelectedTest();
        this.showStatisticsForSelectedProxy(selectedProxy, true);
    }

    private void showStatisticsForSelectedProxy(AbstractTestProxy selectedProxy, boolean requestFocus) {
        if (selectedProxy instanceof SMTestProxy && this.myShowStatisticForProxyHandler != null) {
            this.myShowStatisticForProxyHandler.handlePropagateSelectionRequest((SMTestProxy)selectedProxy, this, requestFocus);
        }
    }

    protected int getTotalTestCount() {
        return this.myTotalTestCount;
    }

    protected int getStartedTestCount() {
        return this.myStartedTestCount;
    }

    protected int getFinishedTestCount() {
        return this.myFinishedTestCount;
    }

    protected int getFailedTestCount() {
        return this.myFailedTestCount;
    }

    protected int getIgnoredTestCount() {
        return this.myIgnoredTestCount;
    }

    protected Color getTestsStatusColor() {
        return this.myStatusLine.getStatusColor();
    }

    public Set<String> getMentionedCategories() {
        return this.myMentionedCategories;
    }

    protected long getStartTime() {
        return this.myStartTime;
    }

    protected long getEndTime() {
        return this.myEndTime;
    }

    private void _addTestOrSuite(@NotNull SMTestProxy newTestOrSuite) {
        if (newTestOrSuite == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "_addTestOrSuite"));
        }
        SMTestProxy parentSuite = newTestOrSuite.getParent();
        assert (parentSuite != null);
        this.myTreeBuilder.updateTestsSubtree(parentSuite);
        this.myTreeBuilder.repaintWithParents(newTestOrSuite);
        this.myAnimator.setCurrentTestCase(newTestOrSuite);
    }

    private void fireOnTestNodeAdded(SMTestProxy test) {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestNodeAdded(this, test);
        }
    }

    private void fireOnTestingFinished() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingFinished(this);
        }
    }

    private void fireOnTestingStarted() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingStarted(this);
        }
    }

    private void selectWithoutNotify(final AbstractTestProxy testProxy, final @Nullable Runnable onDone) {
        if (testProxy == null) {
            return;
        }
        SMRunnerUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (SMTestRunnerResultsForm.this.myTreeBuilder.isDisposed()) {
                    return;
                }
                SMTestRunnerResultsForm.this.myTreeBuilder.select(testProxy, onDone);
            }
        }, ModalityState.NON_MODAL);
    }

    private void updateStatusLabel(boolean testingFinished) {
        if (this.myFailedTestCount > 0) {
            this.myStatusLine.setStatusColor(ColorProgressBar.RED);
        } else if (this.myIgnoredTestCount > 0) {
            this.myStatusLine.setStatusColor(DARK_YELLOW);
        }
        if (testingFinished && this.myTotalTestCount == 0) {
            this.myStatusLine.setStatusColor((Color)(this.myTestsRootNode.wasLaunched() || !this.myTestsRootNode.isTestsReporterAttached() ? JBColor.LIGHT_GRAY : ColorProgressBar.RED));
        }
        boolean launchedAndFinished = this.myTestsRootNode.wasLaunched() && !this.myTestsRootNode.isInProgress();
        this.myStatusLine.setText(TestsPresentationUtil.getProgressStatus_Text(this.myStartTime, this.myEndTime, this.myTotalTestCount, this.myFinishedTestCount, this.myFailedTestCount, this.myMentionedCategories, launchedAndFinished));
    }

    public void performUpdate() {
        this.myTreeBuilder.performUpdate();
    }

    private void updateIconProgress() {
        int doneTestCount;
        int totalTestCount;
        if (this.myTotalTestCount == 0) {
            totalTestCount = 2;
            doneTestCount = 1;
        } else {
            totalTestCount = this.myTotalTestCount;
            doneTestCount = this.myFinishedTestCount + this.myFailedTestCount + this.myIgnoredTestCount;
        }
        TestsUIUtil.showIconProgress(this.myProject, doneTestCount, totalTestCount, this.myFailedTestCount);
    }

    public PropagateSelectionHandler createSelectMeListener() {
        return new PropagateSelectionHandler(){

            @Override
            public void handlePropagateSelectionRequest(final @Nullable SMTestProxy selectedTestProxy, @NotNull Object sender, final boolean requestFocus) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm$6", "handlePropagateSelectionRequest"));
                }
                SMRunnerUtil.addToInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SMTestRunnerResultsForm.this.selectWithoutNotify(selectedTestProxy, null);
                        if (requestFocus) {
                            IdeFocusManager.getInstance((Project)SMTestRunnerResultsForm.this.myProject).requestFocus((Component)((Object)SMTestRunnerResultsForm.this.myTreeView), true);
                        }
                    }
                });
            }
        };
    }

    private void updateCountersAndProgressOnTestCount(int count, boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myTotalTestCount += count;
        this.updateStatusLabel(false);
    }

    private void updateOnTestStarted(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myMentionedCategories.add(this.myCurrentCustomProgressCategory != null ? this.myCurrentCustomProgressCategory : "Tests");
        ++this.myStartedTestCount;
        if (this.myStartedTestCount > this.myTotalTestCount && this.myTotalTestCount != 0) {
            this.myTotalTestCount = this.myStartedTestCount;
        }
        this.updateStatusLabel(false);
    }

    private void updateProgressOnTestDone() {
        int doneTestCount = this.myFinishedTestCount + this.myFailedTestCount + this.myIgnoredTestCount;
        if (this.myTotalTestCount != 0) {
            this.myStatusLine.setFraction((double)doneTestCount / (double)this.myTotalTestCount);
        } else {
            this.myStatusLine.setFraction(doneTestCount > 0 ? 0.5 : 0.0);
        }
    }

    private void updateOnTestFailed(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFailedTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private void updateOnTestFinished(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFinishedTestCount;
        this.updateProgressOnTestDone();
    }

    private void updateOnTestIgnored() {
        ++this.myIgnoredTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private boolean isModeConsistent(boolean isCustomMessage) {
        return isCustomMessage != (this.myCurrentCustomProgressCategory == null);
    }

    private static class MyAnimator
    extends TestsProgressAnimator {
        public MyAnimator(Disposable parentDisposable, AbstractTestTreeBuilder builder) {
            super(parentDisposable);
            this.init(builder);
        }
    }
}

