/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMStacktraceParser;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.NotRunState;
import com.intellij.execution.testframework.sm.runner.states.SuiteFinishedState;
import com.intellij.execution.testframework.sm.runner.states.SuiteInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TerminatedState;
import com.intellij.execution.testframework.sm.runner.states.TestComparisionFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestErrorState;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestIgnoredState;
import com.intellij.execution.testframework.sm.runner.states.TestInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TestPassedState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestProxy
extends AbstractTestProxy {
    private static final Logger LOG = Logger.getInstance((String)SMTestProxy.class.getName());
    private List<SMTestProxy> myChildren;
    private SMTestProxy myParent;
    private AbstractState myState = NotRunState.getInstance();
    private final String myName;
    private Long myDuration = null;
    @Nullable
    private final String myLocationUrl;
    private boolean myDurationIsCached = false;
    private boolean myHasCriticalErrors = false;
    private boolean myHasErrorsCached = false;
    private boolean myHasPassedTests = false;
    private boolean myHasPassedTestsCached = false;
    @Nullable
    private String myStacktrace;
    private final boolean myIsSuite;
    private boolean myIsEmptyIsCached = false;
    private boolean myIsEmpty = true;
    TestLocationProvider myLocator = null;
    private final boolean myPreservePresentableName;
    private Printer myPreferredPrinter = null;

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl) {
        this(testName, isSuite, locationUrl, false);
    }

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl, boolean preservePresentableName) {
        this.myName = testName;
        this.myIsSuite = isSuite;
        this.myLocationUrl = locationUrl;
        this.myPreservePresentableName = preservePresentableName;
    }

    public void setLocator(@NotNull TestLocationProvider locator) {
        if (locator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setLocator"));
        }
        this.myLocator = locator;
    }

    public void setPreferredPrinter(@NotNull Printer preferredPrinter) {
        if (preferredPrinter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setPreferredPrinter"));
        }
        this.myPreferredPrinter = preferredPrinter;
    }

    @Override
    public boolean isInProgress() {
        return this.myState.isInProgress();
    }

    @Override
    public boolean isDefect() {
        return this.myState.isDefect();
    }

    @Override
    public boolean shouldRun() {
        return true;
    }

    @Override
    public int getMagnitude() {
        return this.getMagnitudeInfo().getValue();
    }

    public TestStateInfo.Magnitude getMagnitudeInfo() {
        return this.myState.getMagnitude();
    }

    public boolean hasErrors() {
        if (this.myHasErrorsCached) {
            return this.myHasCriticalErrors;
        }
        boolean canCacheErrors = !this.myState.isInProgress();
        boolean hasErrors = this.calcHasErrors();
        if (canCacheErrors) {
            this.myHasCriticalErrors = hasErrors;
            this.myHasErrorsCached = true;
        }
        return hasErrors;
    }

    private boolean calcHasErrors() {
        if (this.myHasCriticalErrors) {
            return true;
        }
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            if (!sMTestProxy.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public boolean isFinal() {
        return this.myState.isFinal();
    }

    private void setStacktraceIfNotSet(@Nullable String stacktrace) {
        if (this.myStacktrace == null) {
            this.myStacktrace = stacktrace;
        }
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren == null || this.myChildren.isEmpty();
    }

    @Override
    public boolean isInterrupted() {
        return this.myState.wasTerminated();
    }

    boolean hasPassedTests() {
        boolean canCache;
        if (this.myHasPassedTestsCached) {
            return this.myHasPassedTests;
        }
        boolean hasPassedTests = this.calcPassedTests();
        boolean bl = canCache = !this.myState.isInProgress();
        if (canCache) {
            this.myHasPassedTests = hasPassedTests;
            this.myHasPassedTestsCached = true;
        }
        return hasPassedTests;
    }

    private boolean calcPassedTests() {
        if (this.isPassed()) {
            return true;
        }
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            if (!sMTestProxy.hasPassedTests()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnored() {
        if (this.hasPassedTests()) {
            return false;
        }
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.IGNORED_INDEX;
    }

    @Override
    public boolean isPassed() {
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.SKIPPED_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.COMPLETE_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.PASSED_INDEX;
    }

    public void addChild(SMTestProxy child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<SMTestProxy>();
        }
        this.myChildren.add(child);
        this.addLast(child);
        child.setParent(this);
        child.setPrinter(this.myPrinter);
        if (this.myPreferredPrinter != null && child.myPreferredPrinter == null) {
            child.setPreferredPrinter(this.myPreferredPrinter);
        }
    }

    @Nullable
    private Printer getRightPrinter(@Nullable Printer printer) {
        if (this.myPreferredPrinter != null && printer != null) {
            return this.myPreferredPrinter;
        }
        return printer;
    }

    @Override
    public void setPrinter(Printer printer) {
        super.setPrinter(this.getRightPrinter(printer));
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public Location getLocation(Project project, GlobalSearchScope searchScope) {
        List<Location> locations;
        if (this.myLocationUrl == null || this.myLocator == null) {
            return null;
        }
        String protocolId = VirtualFileManager.extractProtocol((String)this.myLocationUrl);
        String path = TestsLocationProviderUtil.extractPath(this.myLocationUrl);
        if (protocolId != null && path != null && !(locations = this.myLocator.getLocation(protocolId, path, project)).isEmpty()) {
            return locations.iterator().next();
        }
        return null;
    }

    @Override
    @Nullable
    public Navigatable getDescriptor(Location location, TestConsoleProperties testConsoleProperties) {
        Navigatable result;
        if (location == null) {
            return null;
        }
        String stacktrace = this.myStacktrace;
        if (stacktrace != null && testConsoleProperties instanceof SMStacktraceParser && this.isLeaf() && (result = ((SMStacktraceParser)((Object)testConsoleProperties)).getErrorNavigatable(location.getProject(), stacktrace)) != null) {
            return result;
        }
        return EditSourceUtil.getDescriptor((PsiElement)location.getPsiElement());
    }

    public boolean isSuite() {
        return this.myIsSuite;
    }

    @Override
    public SMTestProxy getParent() {
        return this.myParent;
    }

    public List<? extends SMTestProxy> getChildren() {
        return this.myChildren != null ? this.myChildren : Collections.emptyList();
    }

    public List<SMTestProxy> getAllTests() {
        ArrayList<SMTestProxy> allTests = new ArrayList<SMTestProxy>();
        allTests.add(this);
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            allTests.addAll(sMTestProxy.getAllTests());
        }
        return allTests;
    }

    public void setStarted() {
        this.myState = !this.myIsSuite ? TestInProgressState.TEST : new SuiteInProgressState(this);
    }

    @Override
    @Nullable
    public Long getDuration() {
        if (this.myDurationIsCached || !this.isSuite()) {
            return this.myDuration;
        }
        this.myDuration = this.calcSuiteDuration();
        this.myDurationIsCached = true;
        return this.myDuration;
    }

    @Override
    public boolean shouldSkipRootNodeForExport() {
        return true;
    }

    public void setDuration(long duration) {
        this.invalidateCachedDurationForContainerSuites();
        if (!this.isSuite()) {
            this.myDurationIsCached = true;
            this.myDuration = duration >= 0L ? Long.valueOf(duration) : null;
            return;
        }
        LOG.warn("Unsupported operation");
    }

    public void setFinished() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = !this.isSuite() ? TestPassedState.INSTANCE : this.determineSuiteStateOnFinished();
        this.fireOnNewPrintable(this.myState);
    }

    public void setTestFailed(@NotNull String localizedMessage, @Nullable String stackTrace, boolean testError) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestFailed"));
        }
        this.setStacktraceIfNotSet(stackTrace);
        if (this.myState instanceof TestFailedState) {
            ((TestFailedState)this.myState).addError(localizedMessage, stackTrace, this.myPrinter);
        } else {
            this.myState = testError ? new TestErrorState(localizedMessage, stackTrace) : new TestFailedState(localizedMessage, stackTrace);
            this.fireOnNewPrintable(this.myState);
        }
    }

    public void setTestComparisonFailed(@NotNull String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestComparisonFailed"));
        }
        if (actualText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestComparisonFailed"));
        }
        if (expectedText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestComparisonFailed"));
        }
        this.setStacktraceIfNotSet(stackTrace);
        this.myState = new TestComparisionFailedState(localizedMessage, stackTrace, actualText, expectedText);
        this.fireOnNewPrintable(this.myState);
    }

    public void setTestIgnored(@Nullable String ignoreComment, @Nullable String stackTrace) {
        this.setStacktraceIfNotSet(stackTrace);
        this.myState = new TestIgnoredState(ignoreComment, stackTrace);
        this.fireOnNewPrintable(this.myState);
    }

    public void setParent(@Nullable SMTestProxy parent) {
        this.myParent = parent;
    }

    public List<? extends SMTestProxy> collectChildren(@Nullable Filter<SMTestProxy> filter) {
        return SMTestProxy.filterChildren(filter, this.collectChildren());
    }

    public List<? extends SMTestProxy> collectChildren() {
        List<? extends SMTestProxy> allChildren = this.getChildren();
        ArrayList result = ContainerUtilRt.newArrayList();
        result.addAll(allChildren);
        for (SMTestProxy sMTestProxy : allChildren) {
            result.addAll(sMTestProxy.collectChildren());
        }
        return result;
    }

    public List<? extends SMTestProxy> getChildren(@Nullable Filter<? super SMTestProxy> filter) {
        List<? extends SMTestProxy> allChildren = this.getChildren();
        return SMTestProxy.filterChildren(filter, allChildren);
    }

    private static List<? extends SMTestProxy> filterChildren(@Nullable Filter<? super SMTestProxy> filter, List<? extends SMTestProxy> allChildren) {
        if (filter == Filter.NO_FILTER || filter == null) {
            return allChildren;
        }
        ArrayList<SMTestProxy> selectedChildren = new ArrayList<SMTestProxy>();
        for (SMTestProxy sMTestProxy : allChildren) {
            if (!filter.shouldAccept(sMTestProxy)) continue;
            selectedChildren.add(sMTestProxy);
        }
        if (selectedChildren.isEmpty()) {
            return Collections.emptyList();
        }
        return selectedChildren;
    }

    public boolean wasLaunched() {
        return this.myState.wasLaunched();
    }

    @Override
    public void printOn(Printer printer) {
        final Printer rightPrinter = this.getRightPrinter(printer);
        super.printOn(rightPrinter);
        final AbstractState oldState = this.myState;
        SMTestProxy.invokeInAlarm(new Runnable(){

            @Override
            public void run() {
                oldState.printOn(rightPrinter);
            }
        });
    }

    public void addStdOutput(final String output, final Key outputType) {
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.getConsoleViewType((Key)outputType));
            }
        });
    }

    public void addStdErr(final String output) {
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.ERROR_OUTPUT);
            }
        });
    }

    @Deprecated
    public void addError(String output, @Nullable String stackTrace) {
        this.addError(output, stackTrace, true);
    }

    public void addError(final String output, final @Nullable String stackTrace, boolean isCritical) {
        this.myHasCriticalErrors = isCritical;
        this.setStacktraceIfNotSet(stackTrace);
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                String errorText = TestFailedState.buildErrorPresentationText(output, stackTrace);
                LOG.assertTrue(errorText != null);
                TestFailedState.printError(printer, Arrays.asList(errorText));
            }
        });
    }

    public void addSystemOutput(final String output) {
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        });
    }

    @NotNull
    public String getPresentableName() {
        if (this.myPreservePresentableName) {
            String string = TestsPresentationUtil.getPresentableNameTrimmedOnly(this);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "getPresentableName"));
            }
            return string;
        }
        String string = TestsPresentationUtil.getPresentableName(this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "getPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    public AbstractTestProxy.AssertEqualsDiffViewerProvider getDiffViewerProvider() {
        if (this.myState instanceof AbstractTestProxy.AssertEqualsDiffViewerProvider) {
            return (AbstractTestProxy.AssertEqualsDiffViewerProvider)((Object)this.myState);
        }
        return null;
    }

    public String toString() {
        return this.getPresentableName();
    }

    public void setTerminated() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = TerminatedState.INSTANCE;
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            sMTestProxy.setTerminated();
        }
        this.fireOnNewPrintable(this.myState);
    }

    public boolean wasTerminated() {
        return this.myState.wasTerminated();
    }

    @Nullable
    protected String getLocationUrl() {
        return this.myLocationUrl;
    }

    private boolean containsErrorTests() {
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            if (sMTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.ERROR_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsFailedTests() {
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            if (sMTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.FAILED_INDEX) continue;
            return true;
        }
        return false;
    }

    protected AbstractState determineSuiteStateOnFinished() {
        SuiteFinishedState state = this.isLeaf() ? SuiteFinishedState.EMPTY_LEAF_SUITE : (this.isEmptySuite() ? SuiteFinishedState.EMPTY_SUITE : (this.isDefect() ? (this.containsErrorTests() ? SuiteFinishedState.ERROR_SUITE : (this.containsFailedTests() ? SuiteFinishedState.FAILED_SUITE : SuiteFinishedState.WITH_IGNORED_TESTS_SUITE)) : SuiteFinishedState.PASSED_SUITE));
        return state;
    }

    public boolean isEmptySuite() {
        if (this.myIsEmptyIsCached) {
            return this.myIsEmpty;
        }
        if (!this.isSuite()) {
            this.myIsEmpty = true;
            this.myIsEmptyIsCached = true;
            return this.myIsEmpty;
        }
        this.myIsEmpty = true;
        List<? extends SMTestProxy> allTestCases = this.getChildren();
        for (SMTestProxy sMTestProxy : allTestCases) {
            if (sMTestProxy.isSuite()) {
                if (!sMTestProxy.isEmptySuite()) {
                    this.myIsEmpty = false;
                    this.myIsEmptyIsCached = true;
                    break;
                }
                this.myIsEmpty = true;
                this.myIsEmptyIsCached = this.myState.isFinal();
                continue;
            }
            this.myIsEmpty = false;
            this.myIsEmptyIsCached = true;
            break;
        }
        return this.myIsEmpty;
    }

    @Nullable
    private Long calcSuiteDuration() {
        long partialDuration = 0L;
        boolean durationOfChildrenIsUnknown = true;
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            Long duration = sMTestProxy.getDuration();
            if (duration == null) continue;
            durationOfChildrenIsUnknown = false;
            partialDuration += duration.longValue();
        }
        return durationOfChildrenIsUnknown ? null : Long.valueOf(partialDuration);
    }

    private void invalidateCachedDurationForContainerSuites() {
        this.myDuration = null;
        this.myDurationIsCached = false;
        SMTestProxy containerSuite = this.getParent();
        if (containerSuite != null) {
            containerSuite.invalidateCachedDurationForContainerSuites();
        }
    }

    public static class SMRootTestProxy
    extends SMTestProxy {
        private boolean myTestsReporterAttached;

        public SMRootTestProxy() {
            super("[root]", true, null);
        }

        public void setTestsReporterAttached() {
            this.myTestsReporterAttached = true;
        }

        public boolean isTestsReporterAttached() {
            return this.myTestsReporterAttached;
        }

        @Override
        protected AbstractState determineSuiteStateOnFinished() {
            if (this.isLeaf() && !this.isTestsReporterAttached()) {
                return SuiteFinishedState.TESTS_REPORTER_NOT_ATTACHED;
            }
            return super.determineSuiteStateOnFinished();
        }
    }
}

