/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMStacktraceParser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.config.Storage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerConsoleProperties
extends TestConsoleProperties
implements SMStacktraceParser {
    private final RunConfiguration myConfiguration;
    protected final CompositeFilter myCustomFilter;
    private final boolean myPrintTestingStartedTime;

    public SMTRunnerConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        this(config, testFrameworkName, executor, true);
    }

    public SMTRunnerConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor, boolean printTestingStartedTime) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        super((Storage)new Storage.PropertiesComponentStorage(testFrameworkName + "Support.", PropertiesComponent.getInstance()), config.getProject(), executor);
        this.myConfiguration = config;
        this.myCustomFilter = new CompositeFilter(config.getProject());
        this.myPrintTestingStartedTime = printTestingStartedTime;
    }

    @Override
    public RunConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public boolean isPrintTestingStartedTime() {
        return this.myPrintTestingStartedTime;
    }

    @Override
    public Navigatable getErrorNavigatable(final @NotNull Project project, @NotNull String stacktrace) {
        String[] lines;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "getErrorNavigatable"));
        }
        if (stacktrace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "getErrorNavigatable"));
        }
        if (this.myCustomFilter.isEmpty()) {
            return null;
        }
        int stacktraceLength = stacktrace.length();
        for (String line : lines = StringUtil.splitByLines((String)stacktrace)) {
            Filter.Result result;
            try {
                result = this.myCustomFilter.applyFilter(line, stacktraceLength);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + this.myCustomFilter + " to '" + line + "'", t);
            }
            if (result == null) continue;
            HyperlinkInfo info = result.hyperlinkInfo;
            if (info instanceof FileHyperlinkInfo) {
                return ((FileHyperlinkInfo)info).getDescriptor();
            }
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    result.hyperlinkInfo.navigate(project);
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }
        return null;
    }

    public void addStackTraceFilter(Filter filter) {
        this.myCustomFilter.addFilter(filter);
    }

    @Nullable
    protected Navigatable findSuitableNavigatableForLine(@NotNull Project project, @NotNull VirtualFile file, int line) {
        PsiFile psi;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "findSuitableNavigatableForLine"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "findSuitableNavigatableForLine"));
        }
        Document doc = FileDocumentManager.getInstance().getDocument(file);
        PsiFile psiFile = psi = doc == null ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(doc);
        if (psi == null) {
            return null;
        }
        int offset = doc.getLineStartOffset(line);
        int endOffset = doc.getLineEndOffset(line);
        for (int i = offset + 1; i < endOffset; ++i) {
            PsiElement el = psi.findElementAt(i);
            if (el == null || el instanceof PsiWhiteSpace) continue;
            offset = el.getTextOffset();
            break;
        }
        return new OpenFileDescriptor(project, file, offset);
    }
}

