/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.testIntegration.TestLocationProvider;
import com.intellij.util.Processor;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GeneralTestEventsProcessor
implements Disposable {
    private TransferToEDTQueue<Runnable> myTransferToEDTQueue = new TransferToEDTQueue("SM queue", (Processor)new Processor<Runnable>(){

        public boolean process(Runnable runnable) {
            runnable.run();
            return true;
        }
    }, this.getDisposedCondition(), 300);

    public abstract void onStartTesting();

    public abstract void onTestsCountInSuite(int var1);

    public abstract void onTestStarted(@NotNull TestStartedEvent var1);

    public abstract void onTestFinished(@NotNull TestFinishedEvent var1);

    public abstract void onTestFailure(@NotNull TestFailedEvent var1);

    public abstract void onTestIgnored(@NotNull TestIgnoredEvent var1);

    public abstract void onTestOutput(@NotNull TestOutputEvent var1);

    public abstract void onSuiteStarted(@NotNull TestSuiteStartedEvent var1);

    public abstract void onSuiteFinished(@NotNull TestSuiteFinishedEvent var1);

    public abstract void onUncapturedOutput(@NotNull String var1, Key var2);

    public abstract void onError(@NotNull String var1, @Nullable String var2, boolean var3);

    public abstract void onCustomProgressTestsCategory(@Nullable String var1, int var2);

    public abstract void onCustomProgressTestStarted();

    public abstract void onCustomProgressTestFailed();

    public abstract void onTestsReporterAttached();

    public abstract void setLocator(@NotNull TestLocationProvider var1);

    public abstract void addEventsListener(@NotNull SMTRunnerEventsListener var1);

    public abstract void onFinishTesting();

    public abstract void setPrinterProvider(@NotNull TestProxyPrinterProvider var1);

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeneralTestEventsProcessor.this.myTransferToEDTQueue.drain();
                }
            });
        }
    }

    public Condition getDisposedCondition() {
        return Condition.FALSE;
    }

    public void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        boolean unitTestMode = application.isUnitTestMode();
        if (unitTestMode) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        } else if (application.isHeadlessEnvironment() || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            this.myTransferToEDTQueue.offer((Object)runnable);
        }
    }
}

