/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TestResultsXmlFormatter {
    private static final String ELEM_RUN = "testrun";
    private static final String ELEM_TEST = "test";
    private static final String ELEM_SUITE = "suite";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DURATION = "duration";
    private static final String ELEM_COUNT = "count";
    private static final String ATTR_VALUE = "value";
    private static final String ELEM_OUTPUT = "output";
    private static final String ATTR_OUTPUT_TYPE = "type";
    private static final String ATTR_STATUS = "status";
    private static final String TOTAL_STATUS = "total";
    private static final String ATTR_FOORTER_TEXT = "footerText";
    private final RunConfiguration myRuntimeConfiguration;
    private final ContentHandler myResultHandler;
    private final AbstractTestProxy myTestRoot;

    public static void execute(AbstractTestProxy root, RunConfiguration runtimeConfiguration, ContentHandler resultHandler) throws SAXException {
        new TestResultsXmlFormatter(root, runtimeConfiguration, resultHandler).execute();
    }

    private TestResultsXmlFormatter(AbstractTestProxy root, RunConfiguration runtimeConfiguration, ContentHandler resultHandler) {
        this.myRuntimeConfiguration = runtimeConfiguration;
        this.myTestRoot = root;
        this.myResultHandler = resultHandler;
    }

    private void execute() throws SAXException {
        this.myResultHandler.startDocument();
        TreeMap<String, Integer> counts = new TreeMap<String, Integer>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (TestResultsXmlFormatter.TOTAL_STATUS.equals(o1) && !TestResultsXmlFormatter.TOTAL_STATUS.equals(o2)) {
                    return -1;
                }
                if (TestResultsXmlFormatter.TOTAL_STATUS.equals(o2) && !TestResultsXmlFormatter.TOTAL_STATUS.equals(o1)) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        for (AbstractTestProxy abstractTestProxy : this.myTestRoot.getAllTests()) {
            if (!abstractTestProxy.isLeaf()) continue;
            String status = TestResultsXmlFormatter.getStatusString(abstractTestProxy);
            TestResultsXmlFormatter.increment(counts, status);
            TestResultsXmlFormatter.increment(counts, TOTAL_STATUS);
        }
        HashMap<String, String> runAttrs = new HashMap<String, String>();
        runAttrs.put(ATTR_NAME, this.myRuntimeConfiguration.getName());
        String string = ExecutionBundle.message((String)"export.test.results.footer", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), new SimpleDateFormat().format(new Date())});
        runAttrs.put(ATTR_FOORTER_TEXT, string);
        Long duration = this.myTestRoot.getDuration();
        if (duration != null) {
            runAttrs.put(ATTR_DURATION, String.valueOf(duration));
        }
        this.startElement(ELEM_RUN, runAttrs);
        for (Map.Entry<String, Integer> entry : counts.entrySet()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(ATTR_NAME, entry.getKey());
            hashMap.put(ATTR_VALUE, String.valueOf(entry.getValue()));
            this.startElement(ELEM_COUNT, hashMap);
            this.endElement(ELEM_COUNT);
        }
        CompositeFilter f = new CompositeFilter(this.myRuntimeConfiguration.getProject());
        for (ConsoleFilterProvider eachProvider : (ConsoleFilterProvider[])Extensions.getExtensions((ExtensionPointName)ConsoleFilterProvider.FILTER_PROVIDERS)) {
            Filter[] filters;
            for (Filter filter : filters = eachProvider.getDefaultFilters(this.myRuntimeConfiguration.getProject())) {
                f.addFilter(filter);
            }
        }
        if (this.myTestRoot.shouldSkipRootNodeForExport()) {
            for (AbstractTestProxy abstractTestProxy : this.myTestRoot.getChildren()) {
                this.processNode(abstractTestProxy, (Filter)f);
            }
        } else {
            this.processNode(this.myTestRoot, (Filter)f);
        }
        this.endElement(ELEM_RUN);
        this.myResultHandler.endDocument();
    }

    private static void increment(Map<String, Integer> counts, String status) {
        Integer count = counts.get(status);
        counts.put(status, count != null ? count + 1 : 1);
    }

    private void processNode(AbstractTestProxy node, final Filter filter) throws SAXException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(ATTR_NAME, node.getName());
        attrs.put(ATTR_STATUS, TestResultsXmlFormatter.getStatusString(node));
        Long duration = node.getDuration();
        if (duration != null) {
            attrs.put(ATTR_DURATION, String.valueOf(duration));
        }
        String elemName = node.isLeaf() ? ELEM_TEST : ELEM_SUITE;
        this.startElement(elemName, attrs);
        if (node.isLeaf()) {
            final StringBuilder buffer = new StringBuilder();
            final Ref ref = new Ref();
            final Ref error = new Ref();
            node.printOn(new Printer(){

                @Override
                public void print(String text, ConsoleViewContentType contentType) {
                    if (contentType != ref.get()) {
                        if (buffer.length() > 0) {
                            try {
                                TestResultsXmlFormatter.this.writeOutput((ConsoleViewContentType)ref.get(), buffer, filter);
                            }
                            catch (SAXException e) {
                                error.set((Object)e);
                            }
                        }
                        ref.set((Object)contentType);
                    }
                    buffer.append(text);
                }

                @Override
                public void onNewAvailable(@NotNull Printable printable) {
                    if (printable == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/export/TestResultsXmlFormatter$2", "onNewAvailable"));
                    }
                }

                @Override
                public void printHyperlink(String text, HyperlinkInfo info) {
                }

                @Override
                public void mark() {
                }
            });
            if (!error.isNull()) {
                throw (SAXException)error.get();
            }
            if (buffer.length() > 0) {
                this.writeOutput((ConsoleViewContentType)ref.get(), buffer, filter);
            }
        } else {
            for (AbstractTestProxy abstractTestProxy : node.getChildren()) {
                this.processNode(abstractTestProxy, filter);
            }
        }
        this.endElement(elemName);
    }

    private void writeOutput(ConsoleViewContentType type, StringBuilder text, Filter filter) throws SAXException {
        StringBuilder output = new StringBuilder();
        StringTokenizer t = new StringTokenizer(text.toString(), "\n");
        while (t.hasMoreTokens()) {
            String line = StringUtil.escapeXml((String)t.nextToken()) + "\n";
            Object result = null;
            if (result != null && result.hyperlinkInfo instanceof OpenFileHyperlinkInfo) {
                output.append(line.substring(0, result.highlightStartOffset));
                OpenFileDescriptor descriptor = ((OpenFileHyperlinkInfo)result.hyperlinkInfo).getDescriptor();
                output.append("<a href=\"javascript://\" onclick=\"Activator.doOpen('file?file=");
                output.append(descriptor.getFile().getPresentableUrl());
                output.append("&line=");
                output.append(descriptor.getLine());
                output.append("')\">");
                output.append(line.substring(result.highlightStartOffset, result.highlightEndOffset));
                output.append("</a>");
                output.append(line.substring(result.highlightEndOffset));
                continue;
            }
            output.append(line);
        }
        HashMap<String, String> a = new HashMap<String, String>();
        a.put(ATTR_OUTPUT_TYPE, TestResultsXmlFormatter.getTypeString(type));
        this.startElement(ELEM_OUTPUT, a);
        this.writeText(output.toString());
        text.delete(0, text.length());
        this.endElement(ELEM_OUTPUT);
    }

    private static String getTypeString(ConsoleViewContentType type) {
        return type == ConsoleViewContentType.ERROR_OUTPUT ? "stderr" : "stdout";
    }

    private static String getStatusString(AbstractTestProxy node) {
        int magnitude = node.getMagnitude();
        switch (magnitude) {
            case 0: {
                return "skipped";
            }
            case 5: {
                return "ignored";
            }
            case 1: {
                return "passed";
            }
            case 6: {
                return "failed";
            }
            case 8: {
                return "error";
            }
        }
        return node.isPassed() ? "passed" : "failed";
    }

    private void startElement(String name, Map<String, String> attributes) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attrs.addAttribute("", entry.getKey(), entry.getKey(), "CDATA", entry.getValue());
        }
        this.myResultHandler.startElement("", name, name, attrs);
    }

    private void endElement(String name) throws SAXException {
        this.myResultHandler.endElement("", name, name);
    }

    private void writeText(String text) throws SAXException {
        char[] chars = text.toCharArray();
        this.myResultHandler.characters(chars, 0, chars.length);
    }
}

