/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.FailedTestsNavigator;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.ToggleModelAction;
import com.intellij.execution.testframework.ToggleModelActionProvider;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.actions.ShowStatisticsAction;
import com.intellij.execution.testframework.actions.TestFrameworkActions;
import com.intellij.execution.testframework.actions.TestTreeExpander;
import com.intellij.execution.testframework.autotest.AdjustAutotestDelayActionGroup;
import com.intellij.execution.testframework.export.ExportTestResultsAction;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.ToggleBooleanProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ToolbarPanel
extends JPanel
implements OccurenceNavigator,
Disposable {
    protected final TestTreeExpander myTreeExpander = new TestTreeExpander();
    protected final FailedTestsNavigator myOccurenceNavigator;
    protected final ScrollToTestSourceAction myScrollToSource;
    private final ExportTestResultsAction myExportAction;
    private final ArrayList<ToggleModelAction> myActions = new ArrayList();

    public ToolbarPanel(TestConsoleProperties properties, ExecutionEnvironment environment, JComponent parent) {
        super(new BorderLayout());
        DefaultActionGroup actionGroup = new DefaultActionGroup(null, false);
        actionGroup.addAction((AnAction)new ToggleBooleanProperty(ExecutionBundle.message((String)"junit.run.hide.passed.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.run.hide.passed.action.description", (Object[])new Object[0]), AllIcons.RunConfigurations.HidePassed, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.HIDE_PASSED_TESTS));
        actionGroup.addSeparator();
        actionGroup.addAction((AnAction)new ToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.track.test.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.track.test.action.description", (Object[])new Object[0]), AllIcons.RunConfigurations.TrackTests, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.TRACK_RUNNING_TEST)).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ToggleBooleanProperty("Hide Ignored", null, AllIcons.RunConfigurations.HideIgnored, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.HIDE_IGNORED_TEST)).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.sort.alphabetically.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.sort.alphabetically.action.description", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SORT_ALPHABETICALLY));
        actionGroup.addSeparator();
        AnAction action = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)this.myTreeExpander, parent);
        action.getTemplatePresentation().setDescription(ExecutionBundle.message((String)"junit.runing.info.expand.test.action.name", (Object[])new Object[0]));
        actionGroup.add(action);
        action = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)this.myTreeExpander, parent);
        action.getTemplatePresentation().setDescription(ExecutionBundle.message((String)"junit.runing.info.collapse.test.action.name", (Object[])new Object[0]));
        actionGroup.add(action);
        actionGroup.addSeparator();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        this.myOccurenceNavigator = new FailedTestsNavigator();
        actionGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        actionGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        actionGroup.addAction((AnAction)new ToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.select.first.failed.action.name", (Object[])new Object[0]), null, AllIcons.RunConfigurations.SelectFirstDefect, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SELECT_FIRST_DEFECT)).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.scroll.to.stacktrace.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.scroll.to.stacktrace.action.description", (Object[])new Object[0]), AllIcons.RunConfigurations.ScrollToStackTrace, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SCROLL_TO_STACK_TRACE)).setAsSecondary(true);
        this.myScrollToSource = new ScrollToTestSourceAction(properties);
        actionGroup.addAction((AnAction)this.myScrollToSource).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.open.source.at.exception.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.open.source.at.exception.action.description", (Object[])new Object[0]), AllIcons.RunConfigurations.SourceAtException, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.OPEN_FAILURE_LINE)).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ShowStatisticsAction(properties)).setAsSecondary(true);
        actionGroup.addAction((AnAction)new AdjustAutotestDelayActionGroup(environment)).setAsSecondary(true);
        for (ToggleModelActionProvider actionProvider : (ToggleModelActionProvider[])Extensions.getExtensions(ToggleModelActionProvider.EP_NAME)) {
            ToggleModelAction toggleModelAction = actionProvider.createToggleModelAction(properties);
            this.myActions.add(toggleModelAction);
            actionGroup.add((AnAction)toggleModelAction);
        }
        this.myExportAction = ExportTestResultsAction.create(properties.getExecutor().getToolWindowId(), properties.getConfiguration());
        actionGroup.addAction((AnAction)this.myExportAction);
        this.appendAdditionalActions(actionGroup, properties, environment, parent);
        this.add((Component)ActionManager.getInstance().createActionToolbar("TestTreeViewToolbar", (ActionGroup)actionGroup, true).getComponent(), "Center");
    }

    protected void appendAdditionalActions(DefaultActionGroup actionGroup, TestConsoleProperties properties, ExecutionEnvironment environment, JComponent parent) {
    }

    public void setModel(final TestFrameworkRunningModel model) {
        TestFrameworkActions.installFilterAction(model);
        this.myScrollToSource.setModel(model);
        this.myTreeExpander.setModel(model);
        this.myOccurenceNavigator.setModel(model);
        this.myExportAction.setModel(model);
        for (ToggleModelAction action : this.myActions) {
            action.setModel(model);
        }
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.SORT_ALPHABETICALLY, new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value) {
                AbstractTestTreeBuilder builder = model.getTreeBuilder();
                if (builder != null) {
                    builder.setTestsComparator(value);
                }
            }
        }, model, true);
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator.hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator.goPreviousOccurence();
    }

    public String getNextOccurenceActionName() {
        return this.myOccurenceNavigator.getNextOccurenceActionName();
    }

    public String getPreviousOccurenceActionName() {
        return this.myOccurenceNavigator.getPreviousOccurenceActionName();
    }

    public void dispose() {
        this.myScrollToSource.setModel(null);
        this.myExportAction.setModel(null);
    }
}

