/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.diagnostic.logging.LogConsoleManagerBase;
import com.intellij.diagnostic.logging.LogFilesManager;
import com.intellij.diagnostic.logging.OutputFileUtil;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RestartAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RunContentBuilder
extends LogConsoleManagerBase {
    @NonNls
    private static final String JAVA_RUNNER = "JavaRunner";
    private final ProgramRunner myRunner;
    private final ArrayList<AnAction> myRunnerActions;
    private ExecutionResult myExecutionResult;
    private final LogFilesManager myManager;
    private RunnerLayoutUi myUi;
    private final Executor myExecutor;

    public RunContentBuilder(@NotNull Project project, ProgramRunner runner, Executor executor, ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/RunContentBuilder", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/execution/runners/RunContentBuilder", "<init>"));
        }
        this(runner, executionResult, environment);
    }

    public RunContentBuilder(ProgramRunner runner, ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/RunContentBuilder", "<init>"));
        }
        super(environment.getProject(), RunContentBuilder.createSearchScope(environment.getProject(), environment.getRunProfile()));
        this.myRunnerActions = new ArrayList();
        this.myRunner = runner;
        this.myExecutor = environment.getExecutor();
        this.myManager = new LogFilesManager(environment.getProject(), this, this);
        this.myExecutionResult = executionResult;
        this.setEnvironment(environment);
    }

    public RunContentBuilder(Project project, ProgramRunner runner, Executor executor) {
        super(project);
        this.myRunnerActions = new ArrayList();
        this.myRunner = runner;
        this.myExecutor = executor;
        this.myManager = new LogFilesManager(project, this, this);
    }

    @NotNull
    public static GlobalSearchScope createSearchScope(Project project, RunProfile runProfile) {
        Module[] modules = null;
        if (runProfile instanceof ModuleRunProfile) {
            modules = ((ModuleRunProfile)runProfile).getModules();
        }
        if (modules == null || modules.length == 0) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder", "createSearchScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)modules[0], (boolean)true);
        for (int idx = 1; idx < modules.length; ++idx) {
            Module module = modules[idx];
            scope = scope.uniteWith(GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder", "createSearchScope"));
        }
        return globalSearchScope;
    }

    public ExecutionResult getExecutionResult() {
        return this.myExecutionResult;
    }

    @Deprecated
    public void setExecutionResult(ExecutionResult executionResult) {
        this.myExecutionResult = executionResult;
    }

    @Override
    public void setEnvironment(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/RunContentBuilder", "setEnvironment"));
        }
        super.setEnvironment(env);
        RunProfile profile = env.getRunProfile();
        if (profile instanceof RunConfigurationBase) {
            this.myManager.registerFileMatcher((RunConfigurationBase)profile);
        }
    }

    public void addAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/RunContentBuilder", "addAction"));
        }
        this.myRunnerActions.add(action);
    }

    private RunContentDescriptor createDescriptor() {
        String id;
        if (this.myExecutionResult == null) {
            throw new IllegalStateException("Missing ExecutionResult");
        }
        ExecutionEnvironment environment = this.getEnvironment();
        if (environment == null) {
            throw new IllegalStateException("Missing ExecutionEnvironment");
        }
        RunProfile profile = environment.getRunProfile();
        ExecutionConsole console = this.myExecutionResult.getExecutionConsole();
        String runnerType = JAVA_RUNNER;
        if (console instanceof ExecutionConsoleEx && (id = ((ExecutionConsoleEx)console).getExecutionConsoleId()) != null) {
            runnerType = "JavaRunner." + id;
        }
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)this.getProject()).create(runnerType, this.myExecutor.getId(), profile.getName(), (Disposable)this);
        this.myUi.getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new MyRunContentDescriptor(profile, this.myExecutionResult, this.myUi.getComponent(), this);
        }
        if (console != null) {
            if (console instanceof ExecutionConsoleEx) {
                ((ExecutionConsoleEx)console).buildUi(this.myUi);
            } else {
                RunContentBuilder.buildConsoleUiDefault(this.myUi, console);
            }
            if (profile instanceof RunConfigurationBase) {
                this.myManager.initLogConsoles((RunConfigurationBase)profile, this.myExecutionResult.getProcessHandler());
                OutputFileUtil.attachDumpListener((RunConfigurationBase)profile, this.myExecutionResult.getProcessHandler(), console);
            }
        }
        MyRunContentDescriptor contentDescriptor = new MyRunContentDescriptor(profile, this.myExecutionResult, this.myUi.getComponent(), this);
        this.myUi.getOptions().setLeftToolbar(this.createActionToolbar(contentDescriptor, this.myUi.getComponent()), "unknown");
        if (profile instanceof RunConfigurationBase && console instanceof ObservableConsoleView && !ApplicationManager.getApplication().isUnitTestMode()) {
            ((ObservableConsoleView)console).addChangeListener((ObservableConsoleView.ChangeListener)new ConsoleToFrontListener((RunConfigurationBase)profile, this.getProject(), this.myExecutor, contentDescriptor, this.myUi), (Disposable)this);
        }
        return contentDescriptor;
    }

    public static void buildConsoleUiDefault(RunnerLayoutUi ui, ExecutionConsole console) {
        Content consoleContent = ui.createContent("ConsoleContent", console.getComponent(), "Console", AllIcons.Debugger.Console, console.getPreferredFocusableComponent());
        consoleContent.setCloseable(false);
        RunContentBuilder.addAdditionalConsoleEditorActions(console, consoleContent);
        ui.addContent(consoleContent, 0, PlaceInGrid.bottom, false);
    }

    public static void addAdditionalConsoleEditorActions(ExecutionConsole console, Content consoleContent) {
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        if (console instanceof ConsoleView) {
            AnAction[] actions;
            for (AnAction goaction : actions = ((ConsoleView)console).createConsoleActions()) {
                consoleActions.add(goaction);
            }
        }
        consoleContent.setActions((ActionGroup)consoleActions, "unknown", console.getComponent());
    }

    private ActionGroup createActionToolbar(RunContentDescriptor contentDescriptor, JComponent component) {
        AnAction[] actions;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        final RestartAction restartAction = new RestartAction(this.myExecutor, this.myRunner, contentDescriptor, this.getEnvironment());
        restartAction.registerShortcut(component);
        actionGroup.add((AnAction)restartAction);
        contentDescriptor.setRestarter(new Runnable(){

            @Override
            public void run() {
                restartAction.restart();
            }
        });
        if (this.myExecutionResult instanceof DefaultExecutionResult && (actions = ((DefaultExecutionResult)this.myExecutionResult).getRestartActions()) != null) {
            actionGroup.addAll(actions);
            if (actions.length > 0) {
                actionGroup.addSeparator();
            }
        }
        AnAction stopAction = ActionManager.getInstance().getAction("Stop");
        actionGroup.add(stopAction);
        if (this.myExecutionResult instanceof DefaultExecutionResult) {
            actionGroup.addAll(((DefaultExecutionResult)this.myExecutionResult).getAdditionalStopActions());
        }
        actionGroup.addAll(this.myExecutionResult.getActions());
        for (AnAction anAction : this.myRunnerActions) {
            if (anAction != null) {
                actionGroup.add(anAction);
                continue;
            }
            actionGroup.addSeparator();
        }
        actionGroup.addSeparator();
        actionGroup.add(this.myUi.getOptions().getLayoutActions());
        actionGroup.addSeparator();
        actionGroup.add(PinToolwindowTabAction.getPinAction());
        actionGroup.add((AnAction)new CloseAction(this.myExecutor, contentDescriptor, this.getProject()));
        String helpId = contentDescriptor.getHelpId();
        actionGroup.add((AnAction)new ContextHelpAction(helpId != null ? helpId : this.myExecutor.getHelpId()));
        return actionGroup;
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return this.myExecutionResult.getProcessHandler();
    }

    public RunContentDescriptor showRunContent(RunContentDescriptor reuseContent) {
        RunContentDescriptor descriptor = this.createDescriptor();
        if (reuseContent != null) {
            descriptor.setAttachedContent(reuseContent.getAttachedContent());
        }
        return descriptor;
    }

    @Override
    protected RunnerLayoutUi getUi() {
        return this.myUi;
    }

    @Override
    protected Icon getDefaultIcon() {
        return AllIcons.Debugger.Console;
    }

    public static class ConsoleToFrontListener
    implements ObservableConsoleView.ChangeListener {
        @NotNull
        private final RunConfigurationBase myRunConfigurationBase;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Executor myExecutor;
        @NotNull
        private final RunContentDescriptor myRunContentDescriptor;
        @NotNull
        private final RunnerLayoutUi myUi;

        public ConsoleToFrontListener(@NotNull RunConfigurationBase runConfigurationBase, @NotNull Project project, @NotNull Executor executor, @NotNull RunContentDescriptor runContentDescriptor, @NotNull RunnerLayoutUi ui) {
            if (runConfigurationBase == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener", "<init>"));
            }
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener", "<init>"));
            }
            if (runContentDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener", "<init>"));
            }
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener", "<init>"));
            }
            this.myRunConfigurationBase = runConfigurationBase;
            this.myProject = project;
            this.myExecutor = executor;
            this.myRunContentDescriptor = runContentDescriptor;
            this.myUi = ui;
        }

        public void contentAdded(Collection<ConsoleViewContentType> types) {
            if (this.myProject.isDisposed() || this.myUi.isDisposed()) {
                return;
            }
            for (ConsoleViewContentType type : types) {
                if ((type != ConsoleViewContentType.NORMAL_OUTPUT || !this.myRunConfigurationBase.isShowConsoleOnStdOut()) && (type != ConsoleViewContentType.ERROR_OUTPUT || !this.myRunConfigurationBase.isShowConsoleOnStdErr())) continue;
                ExecutionManager.getInstance((Project)this.myProject).getContentManager().toFrontRunContent(this.myExecutor, this.myRunContentDescriptor);
                this.myUi.selectAndFocus(this.myUi.findContent("ConsoleContent"), false, false);
                return;
            }
        }
    }

    private static class MyRunContentDescriptor
    extends RunContentDescriptor {
        private final Disposable myAdditionalDisposable;

        public MyRunContentDescriptor(RunProfile profile, ExecutionResult executionResult, JComponent component, @NotNull Disposable additionalDisposable) {
            if (additionalDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/runners/RunContentBuilder$MyRunContentDescriptor", "<init>"));
            }
            super(executionResult.getExecutionConsole(), executionResult.getProcessHandler(), component, profile.getName(), profile.getIcon());
            this.myAdditionalDisposable = additionalDisposable;
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myAdditionalDisposable);
            super.dispose();
        }
    }
}

