/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RerunTestsAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    public static final String ID = "RerunTests";
    private static final List<RerunInfo> REGISTRY = ContainerUtil.createLockFreeCopyOnWriteList();

    public static void register(@NotNull RunContentDescriptor descriptor, @NotNull ExecutionEnvironment env, @NotNull ProgramRunner runner) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/RerunTestsAction", "register"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/RerunTestsAction", "register"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/RerunTestsAction", "register"));
        }
        final RerunInfo rerunInfo = new RerunInfo(descriptor, env, runner);
        REGISTRY.add(rerunInfo);
        Disposer.register((Disposable)descriptor, (Disposable)new Disposable(){

            public void dispose() {
                REGISTRY.remove(rerunInfo);
            }
        });
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        ExecutionManager executionManager = ExecutionManager.getInstance((Project)project);
        for (RerunInfo rerunInfo : REGISTRY) {
            RunContentDescriptor descriptor = rerunInfo.getDescriptor();
            if (Disposer.isDisposed((Disposable)descriptor)) continue;
            ExecutionEnvironment env = rerunInfo.getEnv();
            ProgramRunner runner = rerunInfo.getRunner();
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || !processHandler.isProcessTerminated() || ExecutorRegistry.getInstance().isStarting(project, env.getExecutor().getId(), runner.getRunnerId())) continue;
            executionManager.restartRunProfile(runner, env, descriptor);
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(true);
    }

    private static class RerunInfo {
        private final RunContentDescriptor myDescriptor;
        private final ExecutionEnvironment myEnv;
        private final ProgramRunner myRunner;

        public RerunInfo(@NotNull RunContentDescriptor descriptor, @NotNull ExecutionEnvironment env, @NotNull ProgramRunner runner) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/RerunTestsAction$RerunInfo", "<init>"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/RerunTestsAction$RerunInfo", "<init>"));
            }
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/RerunTestsAction$RerunInfo", "<init>"));
            }
            this.myDescriptor = descriptor;
            this.myEnv = env;
            this.myRunner = runner;
        }

        private RunContentDescriptor getDescriptor() {
            return this.myDescriptor;
        }

        private ExecutionEnvironment getEnv() {
            return this.myEnv;
        }

        private ProgramRunner getRunner() {
            return this.myRunner;
        }
    }
}

