/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.LanguageConsoleViewImpl;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ConsoleExecuteActionHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.CommonActionsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.SideBorder;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConsoleRunnerWithHistory<T extends LanguageConsoleView> {
    private final String myConsoleTitle;
    private ProcessHandler myProcessHandler;
    private final String myWorkingDir;
    private T myConsoleView;
    private final Project myProject;
    private ProcessBackedConsoleExecuteActionHandler myConsoleExecuteActionHandler;

    public AbstractConsoleRunnerWithHistory(@NotNull Project project, @NotNull String consoleTitle, @Nullable String workingDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "<init>"));
        }
        if (consoleTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "<init>"));
        }
        this.myProject = project;
        this.myConsoleTitle = consoleTitle;
        this.myWorkingDir = workingDir;
    }

    public void initAndRun() throws ExecutionException {
        final Process process = this.createProcess();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractConsoleRunnerWithHistory.this.initConsoleUI(process);
            }
        });
    }

    private void initConsoleUI(Process process) {
        this.myConsoleView = this.createConsoleView();
        if (this.myConsoleView instanceof LanguageConsoleViewImpl) {
            ((LanguageConsoleViewImpl)this.myConsoleView).setBorder((Border)new SideBorder(UIUtil.getBorderColor(), 1));
        }
        this.myProcessHandler = this.createProcessHandler(process);
        this.myConsoleExecuteActionHandler = this.createExecuteActionHandler();
        ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                AbstractConsoleRunnerWithHistory.this.finishConsole();
            }
        });
        this.myConsoleView.attachToProcess(this.myProcessHandler);
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)actionToolbar.getComponent(), "West");
        panel.add((Component)this.myConsoleView.getComponent(), "Center");
        actionToolbar.setTargetComponent((JComponent)panel);
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(this.myConsoleView, this.myProcessHandler, (JComponent)panel, this.constructConsoleTitle(this.myConsoleTitle));
        contentDescriptor.setFocusComputable((Computable)new Computable<JComponent>(){

            public JComponent compute() {
                return AbstractConsoleRunnerWithHistory.this.getLanguageConsole().getConsoleEditor().getContentComponent();
            }
        });
        contentDescriptor.setAutoFocusContent(this.isAutoFocusContent());
        List<AnAction> actions = this.fillToolBarActions(toolbarActions, defaultExecutor, contentDescriptor);
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions, this.getLanguageConsole().getConsoleEditor().getComponent());
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions, panel);
        panel.updateUI();
        this.showConsole(defaultExecutor, contentDescriptor);
        this.myProcessHandler.startNotify();
    }

    private String constructConsoleTitle(final @NotNull String consoleTitle) {
        if (consoleTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "constructConsoleTitle"));
        }
        if (this.shouldAddNumberToTitle()) {
            List<RunContentDescriptor> consoles = ExecutionHelper.collectConsolesByDisplayName(this.myProject, new NotNullFunction<String, Boolean>(){

                @NotNull
                public Boolean fun(String dom) {
                    Boolean bl = dom.contains(consoleTitle);
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory$4", "fun"));
                    }
                    return bl;
                }
            });
            int max = 0;
            for (RunContentDescriptor dsc : consoles) {
                ProcessHandler handler = dsc.getProcessHandler();
                if (handler == null || handler.isProcessTerminated()) continue;
                if (max == 0) {
                    max = 1;
                }
                try {
                    int num = Integer.parseInt(dsc.getDisplayName().substring(consoleTitle.length() + 1, dsc.getDisplayName().length() - 1));
                    if (num <= max) continue;
                    max = num;
                }
                catch (Exception ignored) {}
            }
            if (max >= 1) {
                return consoleTitle + "(" + (max + 1) + ")";
            }
        }
        return consoleTitle;
    }

    public boolean isAutoFocusContent() {
        return true;
    }

    protected boolean shouldAddNumberToTitle() {
        return false;
    }

    protected void showConsole(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(defaultExecutor, myDescriptor);
    }

    protected void finishConsole() {
        this.myConsoleView.getConsole().setEditable(false);
    }

    protected abstract T createConsoleView();

    @Nullable
    protected abstract Process createProcess() throws ExecutionException;

    protected abstract OSProcessHandler createProcessHandler(Process var1);

    public static void registerActionShortcuts(List<AnAction> actions, JComponent component) {
        for (AnAction action : actions) {
            if (action.getShortcutSet() == null) continue;
            action.registerCustomShortcutSet(action.getShortcutSet(), component);
        }
    }

    protected List<AnAction> fillToolBarActions(DefaultActionGroup toolbarActions, Executor defaultExecutor, RunContentDescriptor contentDescriptor) {
        ArrayList actionList = ContainerUtil.newArrayList();
        actionList.add(this.createStopAction());
        actionList.add(this.createCloseAction(defaultExecutor, contentDescriptor));
        actionList.add(this.createConsoleExecAction(this.myConsoleExecuteActionHandler));
        actionList.add(CommonActionsManager.getInstance().createHelpAction("interactive_console"));
        toolbarActions.addAll((Collection)actionList);
        return actionList;
    }

    protected AnAction createCloseAction(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        return new CloseAction(defaultExecutor, myDescriptor, this.myProject);
    }

    protected AnAction createStopAction() {
        return ActionManager.getInstance().getAction("Stop");
    }

    public LanguageConsoleImpl getLanguageConsole() {
        return this.myConsoleView.getConsole();
    }

    @Deprecated
    public static AnAction createConsoleExecAction(@NotNull LanguageConsoleView console, @NotNull ProcessHandler processHandler, @NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "createConsoleExecAction"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "createConsoleExecAction"));
        }
        if (consoleExecuteActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "createConsoleExecAction"));
        }
        return new ConsoleExecuteAction(console, consoleExecuteActionHandler, consoleExecuteActionHandler.getEmptyExecuteAction(), consoleExecuteActionHandler);
    }

    protected AnAction createConsoleExecAction(@NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (consoleExecuteActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "createConsoleExecAction"));
        }
        return new ConsoleExecuteAction((LanguageConsoleView)this.myConsoleView, consoleExecuteActionHandler, consoleExecuteActionHandler.getEmptyExecuteAction(), consoleExecuteActionHandler);
    }

    @Deprecated
    public static AnAction createConsoleExecAction(LanguageConsoleImpl languageConsole, ProcessHandler processHandler, ConsoleExecuteActionHandler consoleExecuteActionHandler) {
        return ConsoleExecuteAction.createAction(languageConsole, consoleExecuteActionHandler);
    }

    @NotNull
    protected ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler() {
        ConsoleExecuteActionHandler consoleExecuteActionHandler = this.createConsoleExecuteActionHandler();
        if (consoleExecuteActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "createExecuteActionHandler"));
        }
        return consoleExecuteActionHandler;
    }

    @Deprecated
    protected ConsoleExecuteActionHandler createConsoleExecuteActionHandler() {
        throw new AbstractMethodError();
    }

    public T getConsoleView() {
        return this.myConsoleView;
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getConsoleTitle() {
        return this.myConsoleTitle;
    }

    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public ProcessBackedConsoleExecuteActionHandler getConsoleExecuteActionHandler() {
        return this.myConsoleExecuteActionHandler;
    }
}

