/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.RunnerMediator;
import com.intellij.openapi.util.SystemInfo;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class RunnerWinProcess
extends Process {
    private final Process myOriginalProcess;

    private RunnerWinProcess(@NotNull Process originalProcess) {
        if (originalProcess == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/process/RunnerWinProcess", "<init>"));
        }
        this.myOriginalProcess = originalProcess;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.myOriginalProcess.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.myOriginalProcess.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.myOriginalProcess.getErrorStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.myOriginalProcess.waitFor();
    }

    @Override
    public int exitValue() {
        return this.myOriginalProcess.exitValue();
    }

    @Override
    public void destroy() {
        this.myOriginalProcess.destroy();
    }

    public Process getOriginalProcess() {
        return this.myOriginalProcess;
    }

    public void destroyGracefully(boolean softKill) {
        RunnerMediator.destroyProcess(this, softKill);
    }

    @NotNull
    public static RunnerWinProcess create(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/process/RunnerWinProcess", "create"));
        }
        if (!SystemInfo.isWindows) {
            throw new RuntimeException(RunnerWinProcess.class.getSimpleName() + " works on Windows only!");
        }
        RunnerMediator.injectRunnerCommand(commandLine);
        Process process = commandLine.createProcess();
        RunnerWinProcess runnerWinProcess = new RunnerWinProcess(process);
        if (runnerWinProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/RunnerWinProcess", "create"));
        }
        return runnerWinProcess;
    }
}

