/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class InheritorChooser {
    protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
        performRunnable.run();
    }

    protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
        performRunnable.run();
    }

    public boolean runMethodInAbstractClass(ConfigurationContext context, Runnable performRunnable, PsiMethod psiMethod, PsiClass containingClass) {
        return this.runMethodInAbstractClass(context, performRunnable, psiMethod, containingClass, (Condition<PsiClass>)Condition.TRUE);
    }

    public boolean runMethodInAbstractClass(final ConfigurationContext context, final Runnable performRunnable, final PsiMethod psiMethod, final PsiClass containingClass, Condition<PsiClass> acceptAbstractCondition) {
        if (containingClass != null && containingClass.hasModifierProperty("abstract") && acceptAbstractCondition.value((Object)containingClass)) {
            PsiClass aClass;
            Location location = context.getLocation();
            if (location instanceof MethodLocation ? (aClass = ((MethodLocation)location).getContainingClass()) != null && !aClass.hasModifierProperty("abstract") : location instanceof PsiMemberParameterizedLocation) {
                return false;
            }
            final ArrayList classes = new ArrayList();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ClassInheritorsSearch.search((PsiClass)containingClass).forEach((Processor)new Processor<PsiClass>(){

                        public boolean process(PsiClass aClass) {
                            if (PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true, (boolean)true)) {
                                classes.add(aClass);
                            }
                            return true;
                        }
                    });
                }
            }, "Search for " + containingClass.getQualifiedName() + " inheritors", true, containingClass.getProject())) {
                return true;
            }
            if (classes.size() == 1) {
                this.runForClass((PsiClass)classes.get(0), psiMethod, context, performRunnable);
                return true;
            }
            if (classes.isEmpty()) {
                return false;
            }
            FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context.getDataContext());
            if (fileEditor instanceof TextEditor) {
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                PsiFile containingFile = PsiDocumentManager.getInstance((Project)context.getProject()).getPsiFile(document);
                if (containingFile instanceof PsiClassOwner) {
                    ArrayList<PsiClass> psiClasses = new ArrayList<PsiClass>(Arrays.asList(((PsiClassOwner)containingFile).getClasses()));
                    psiClasses.retainAll(classes);
                    if (psiClasses.size() == 1) {
                        this.runForClass((PsiClass)psiClasses.get(0), psiMethod, context, performRunnable);
                        return true;
                    }
                }
            }
            PsiClassListCellRenderer renderer = new PsiClassListCellRenderer(){

                @Override
                protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value == null) {
                        renderer.append("All");
                        return true;
                    }
                    return super.customizeNonPsiElementLeftRenderer(renderer, list, value, index, selected, hasFocus);
                }
            };
            Collections.sort(classes, renderer.getComparator());
            classes.add(0, null);
            final JBList list = new JBList(classes);
            list.setCellRenderer((ListCellRenderer)renderer);
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose executable classes to run " + (psiMethod != null ? psiMethod.getName() : containingClass.getName())).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    Object[] values = list.getSelectedValues();
                    if (values == null) {
                        return;
                    }
                    InheritorChooser.this.chooseAndPerform(values, psiMethod, context, performRunnable, classes);
                }
            }).createPopup().showInBestPositionFor(context.getDataContext());
            return true;
        }
        return false;
    }

    private void chooseAndPerform(Object[] values, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable, List<PsiClass> classes) {
        classes.remove(null);
        if (values.length == 1) {
            Object value = values[0];
            if (value instanceof PsiClass) {
                this.runForClass((PsiClass)value, psiMethod, context, performRunnable);
            } else {
                this.runForClasses(classes, psiMethod, context, performRunnable);
            }
            return;
        }
        if (ArrayUtil.contains(null, (Object[])values)) {
            this.runForClasses(classes, psiMethod, context, performRunnable);
        } else {
            ArrayList<PsiClass> selectedClasses = new ArrayList<PsiClass>();
            for (Object value : values) {
                if (!(value instanceof PsiClass)) continue;
                selectedClasses.add((PsiClass)value);
            }
            this.runForClasses(selectedClasses, psiMethod, context, performRunnable);
        }
    }
}

