/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRunConfigurationTypeUsagesCollector
extends AbstractApplicationUsagesCollector {
    protected abstract boolean isApplicable(@NotNull RunManager var1, @NotNull RunnerAndConfigurationSettings var2);

    @Override
    @NotNull
    public final Set<UsageDescriptor> getProjectUsages(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/statistics/AbstractRunConfigurationTypeUsagesCollector", "getProjectUsages"));
        }
        HashSet runConfigurationTypes = new HashSet();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable((Set)runConfigurationTypes){
            final /* synthetic */ Set val$runConfigurationTypes;
            {
                this.val$runConfigurationTypes = set;
            }

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                RunManager runManager = RunManager.getInstance((Project)project);
                for (RunnerAndConfigurationSettings settings : runManager.getAllSettings()) {
                    RunConfiguration runConfiguration = settings.getConfiguration();
                    if (runConfiguration == null || !AbstractRunConfigurationTypeUsagesCollector.this.isApplicable(runManager, settings)) continue;
                    ConfigurationFactory configurationFactory = runConfiguration.getFactory();
                    ConfigurationType configurationType = configurationFactory.getType();
                    StringBuilder keyBuilder = new StringBuilder();
                    keyBuilder.append(configurationType.getId());
                    if (configurationType.getConfigurationFactories().length > 1) {
                        keyBuilder.append(".").append(configurationFactory.getName());
                    }
                    this.val$runConfigurationTypes.add(keyBuilder.toString());
                }
            }
        });
        Set set = ContainerUtil.map2Set((Collection)runConfigurationTypes, (Function)new Function<String, UsageDescriptor>(){

            public UsageDescriptor fun(String runConfigurationType) {
                return new UsageDescriptor(runConfigurationType, 1);
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/statistics/AbstractRunConfigurationTypeUsagesCollector", "getProjectUsages"));
        }
        return set;
    }
}

